<?php $__env->startSection('extrajs'); ?>
    <script src="<?php echo e(asset('js/jquery.maskMoney.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php
        $urlParams = [
            'id_cliente' => ($ehMultisafe ? $cliente->client_id : $cliente->id),
            'id_multisafe' => ($ehMultisafe ? $cliente->id : 0)
        ];
    ?>

<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 my-3">
            <h2>Ativação de <?php echo e($ehD1 ?? 'D+0'); ?> Automático</h2>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">

                <form action="<?php echo e(route('clientes.dautomatico.ativar', $urlParams)); ?>" method="POST">

                    <?php echo csrf_field(); ?>

                    <div class="card-body">

                        <h4 class="my-2">Dados do Cliente</h4>
                        <div class="form-group row">
                            <label for="nickname" class="col-sm-3 col-form-label">Nome</label>
                            <div class="col-sm-9">
                            <input type="text" readonly class="form-control" id="nickname" name="nickname" value="<?php echo e($cliente->nickname); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="fromtaxnumber" class="col-sm-3 col-form-label">CPF/CNPJ</label>
                            <div class="col-sm-9">
                            <input type="text" readonly class="form-control" id="fromtaxnumber" name="fromtaxnumber" value="<?php echo e($cliente->taxnumber); ?>">
                            </div>
                        </div>


                        <hr class="my-2" />

                        <h4 class="my-2">Dados da Operação</h4>

                        <div class="form-group row">
                            <label for="operationtype" class="col-sm-3 col-form-label">Tipo</label>
                            <div class="col-sm-9">
                            <input type="text" readonly class="form-control" id="operationtype" name="operationtype" value="<?php echo e($ehD1 ?? 'D+0'); ?>" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="operationtime" class="col-sm-3 col-form-label">Horário</label>
                            <div class="col-sm-9">
                            <select class="form-control" id="operationtime" name="operationtime" required>
                                <option value="">- Selecione -</option>
                                <option value="00:00">00:00</option>
                                <option value="09:00">09:00</option>
                                <option value="10:00">10:00</option>
                                <option value="11:00">11:00</option>
                                <option value="12:00">12:00</option>
                                <option value="13:00">13:00</option>
                                <option value="14:00">14:00</option>
                                <option value="15:00">15:00</option>
                                <?php if(!$ehD1): ?>
                                <option value="19:00">19:00</option>
                                <?php endif; ?>
                            </select>
                            </div>
                        </div>

                        <hr class="my-2" />

                        <h4 class="my-2">Dados do Destinatário</h4>

                        <div class="form-group row">
                            <label for="totaxnumber" class="col-sm-3 col-form-label">Documento</label>
                            <div class="col-sm-9">
                                <input type="number" class="form-control" id="totaxnumber" name="totaxnumber" placeholder="CPF/CNPJ" oninput="this.value=this.value.replace(/[^0-9]/g,'');" title="Insira apenas números." required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="tonickname" class="col-sm-3 col-form-label">Nome</label>
                            <div class="col-sm-9">
                            <input type="text" class="form-control" id="tonickname" name="tonickname" placeholder="Nome" required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="toidentifier" class="col-sm-3 col-form-label">Identificador</label>
                            <div class="col-sm-9">
                            <input type="text" class="form-control" id="toidentifier" name="toidentifier" placeholder="Identificador"
                            value="<?php echo e(($ehD1 ? 'D1' : 'D0')); ?> Automatico" required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="accounttype" class="col-sm-3 col-form-label">Tipo de Conta</label>
                            <div class="col-sm-9">
                            <select class="form-control" id="accounttype" name="accounttype" required>
                                <option value="0" selected>Conta Corrente</option>
                                <option value="1">Conta Poupança</option>
                            </select>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="bank_id" class="col-sm-3 col-form-label">Banco</label>
                            <div class="col-sm-9">
                                <?php if(!$bancos): ?>
                                    <p class="text-danger">Houve um problema ao carregar a lista de bancos. Por favor tente mais tarde.</p>
                                <?php else: ?>
                                    <select id="banco" class="form-control" name="bank_id" required>
                                        <option value=""> - Selecione - </option>
                                        <?php $__currentLoopData = json_decode($bancos); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($banco->code); ?>"><?php echo e($banco->code.' - '.$banco->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="bankbranch" class="col-sm-3 col-form-label">Agência (sem dígito)</label>
                            <div class="col-sm-9">
                            <input type="text" class="form-control" id="bankbranch" name="bankbranch" placeholder="Agência (sem dígito)" oninput="this.value=this.value.replace(/[^0-9]/g,'');" title="Insira apenas números." required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="bankaccount" class="col-sm-3 col-form-label">Conta (sem dígito)</label>
                            <div class="col-sm-9">
                            <input type="text" class="form-control" id="bankaccount" name="bankaccount" placeholder="Conta (sem dígito)" oninput="this.value=this.value.replace(/[^0-9]/g,'');" title="Insira apenas números." required>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="bankaccountdigit" class="col-sm-3 col-form-label">Dígito da Conta</label>
                            <div class="col-sm-9">
                            <input type="text" class="form-control" id="bankaccountdigit" name="bankaccountdigit" placeholder="Dígito da Conta" oninput="this.value=this.value.replace(/[^0-9]/g,'');" title="Insira apenas números." required>
                            </div>
                        </div>


                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-success waves-effect waves-light">Ativar</button>
                    </div>

                </form>

            </div>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('inlinejs'); ?>
<script>
    const token = document.querySelector('meta[name=csrf-token]').content;
    const documentoInput = document.querySelector('#totaxnumber');
    documentoInput.addEventListener('focusout', (e) => {
        let taxnumber = e.target.value;
        if (taxnumber) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });
            $.ajax({
                type: 'POST',
                url: "<?php echo e(route('clientes.dautomatico.buscardocumento')); ?>",
                data: { taxnumber },
                dataType: 'JSON',
                success: (response) => {
                    document.querySelector('#tonickname').value = response.nickname ?? null;
                }
            })
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.authenticated', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/ssg-bank/resources/views/clients/d0automatico.blade.php ENDPATH**/ ?>