<?php $__env->startSection('content'); ?>
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    <?php if(!empty($multicnpj)): ?>
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        <?php echo $multiCofres; ?>

    <?php endif; ?>
    
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
                <!-- CARD HEADER -->
                <div class="card-header d-flex justify-content-between pb-0">
                    <h4 class="card-title">Resumo</h4>
                    <div class="dropdown chart-dropdown">
                        <button class="btn btn-sm border-0 p-0" type="button" aria-expanded="false">
                            Última atualização em <?php echo e(date('d/m/Y - H:i')); ?>

                        </button>
                    </div>
                </div>
                <!-- /CARD HEADER -->

                <?php // $smartsafeInfo = getLastCollectSmartsafe()?>

                <?php $saldoFitbank = ($extrato && isset($extrato['Balance']))?$extrato['Balance']:0 ?>
                <?php $saldoDisponivel = ($client->allowlimit==1)?($saldoFitbank + $saldocompensar):$saldoFitbank ?>

                <div class="card-content">
                    <div class="card-body">
                        <div class="row pb-50">
                            <div class="col-12 d-flex justify-content-between flex-column order-lg-1 order-2 mt-lg-0 mt-2">
                                <div>
                                    <h5 class="font-medium-2">
                                        <span>SALDO REAL</span>
                                    </h5>
                                </div>
                            </div>
                        </div>
                        <div class="row pb-50">
                            <div class="col-12 d-flex justify-content-between flex-column order-lg-1 order-2 mt-lg-0 mt-2 text-right">
                                <div>
                                    <h2 class="text-bold-700 mb-25 <?php echo e(($saldoFitbank<0)?'text-danger':'text-success'); ?>">R$ <?php echo e(formatMoneyBr($saldoFitbank)); ?></h2>
                                </div>
                            </div>
                        </div>
                        <?php if($client->allowlimit==1): ?>
                            <hr />
                            <div class="row pb-50">
                                <div class="col-12 d-flex justify-content-between flex-column order-lg-1 order-2 mt-lg-0 mt-2">
                                    <div>
                                        <h5 class="font-medium-2">
                                            <span>SALDO A COMPENSAR<sup>*</sup></span>
                                        </h5>
                                    </div>
                                </div>
                            </div>
                            <div class="row pb-50">
                                <div class="col-12 d-flex justify-content-between flex-column order-lg-1 order-2 mt-lg-0 mt-2 text-right">
                                    <div>
                                        <h2 class="text-bold-700 mb-25">R$ <?php echo e(formatMoneyBr($saldocompensar)); ?></h2>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <hr />
                        <div class="row pb-50">
                            <div class="col-12 d-flex justify-content-between flex-column order-lg-1 order-2 mt-lg-0 mt-2">
                                <div>
                                    <h5 class="font-medium-2">
                                        <span>TOTAL DISPONÍVEL</span>
                                    </h5>
                                </div>
                            </div>
                        </div>
                        <div class="row pb-50">
                            <div class="col-12 d-flex justify-content-between flex-column order-lg-1 order-2 mt-lg-0 mt-2 text-right">
                                <div>
                                    <h2 class="text-bold-700 mb-25 <?php echo e(($saldoFitbank<0)?'text-danger':'text-success'); ?>">R$ <?php echo e(formatMoneyBr($saldoDisponivel)); ?></h2>
                                </div>
                            </div>
                        </div>
                        <hr />
                        <div class="row pt-50 text-center">
                            <div class="col-12">
                                <a href="<?php echo e(url('/extrato')); ?>" class="btn btn-primary shadow">Ver extrato <i class="feather icon-chevrons-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="text-center font-small-3 text-muted">(*) Saldo a compensar refere-se aos valores ainda presentes nos cofres ou coletados que ainda estão sob custódia da transportadora de valores.</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.authenticated', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/ssg-bank/resources/views/home.blade.php ENDPATH**/ ?>