@extends('layouts.authenticated')

@section('title')
 // Titulo da seção
@endsection

@section('panel_title')
// Titulo do painel, se houver
@endsection

@section('content')
<div class="container">
	<div id="alertmessage" class="row justify-content-md-center text-center separator-b-10">
		<div id="alertmessage" class="col-md-8 col-12 text-right">
			@if (session('status'))
		        <div class="bg-info clearfix">
		            {{ session('status') }}
		        </div>
		    @endif
		</div>
	</div>

    <div class="row justify-content-md-center text-right separator-b-10">
		<div class="col-md-8 col-12 text-right">
			<button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light" data-toggle="modal" data-target="#inlineForm"><i class="feather icon-user-plus"></i></button>
		</div>
	</div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			@foreach($users as $user)
				<div class="card">
		            <div class="card-body">
		                <div class="mt-1">
		                    <h6 class="mb-0 {{ ($user->active==0)?'text-muted':'' }}">{{ $user->name }}</h6>
                                @if($user->role_id==1) <div class="badge badge-info mr-1 mb-1">Admin</div> @endif
                                @if($user->active==0) <div class="badge badge-light mr-1 mb-1">Inativo</div> @endif
		                    <p class="{{ ($user->active==0)?'text-muted':'' }}">{{ $user->email }}</p>
		                </div>
		                <div class="mt-1 text-right">
                            <a href="#" data-toggle="modal" data-target="#editar-{{ $user->id }}">
		                      <i class="feather icon-edit text-primary"></i>
                            </a>
                            &nbsp;&nbsp;&nbsp;
                            <a href="#" data-toggle="modal" data-target="#status-{{ $user->id }}">
		                      <i class="feather {{ ($user->active==0)?'text-success icon-user-check':'text-danger icon-user-x' }}"></i>
                            </a>
		                </div>
		            </div>
		        </div>

                {{-- MODAL EDITA USUARIO --}}
                <div class="modal fade text-left" id="editar-{{ $user->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel33">{{ $user->name }} - Editar</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                            <form action="{{ url('/usuarios/'.$user->id.'/atualizar') }}" method="POST">
                                @csrf
                                <div class="modal-body">
                                    <input type="hidden" name="client_id" value="0">
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    
                                    <label>Nome: </label>
                                    <div class="form-group">
                                        <input type="text" name="name" placeholder="Nome" class="form-control" value="{{ $user->name }}">
                                    </div>

                                    <label>Email: </label>
                                    <div class="form-group">
                                        <input type="text" name="email" placeholder="Email Address" class="form-control" value="{{ $user->email }}">
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                {{-- MODAL EDITA USUARIO --}}

                {{-- MODAL STATUS USUARIO --}}
                <div class="modal fade text-left" id="status-{{ $user->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title" id="myModalLabel33">{{ $user->name }} - {{ ($user->active==1)?'Desativar':'Ativar' }}</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                            </div>
                            <form action="{{ url('/usuarios/'.$user->id.'/mudastatus') }}" method="POST">
                                @csrf
                                <div class="modal-body">
                                    <input type="hidden" name="client_id" value="0">
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">{{ ($user->active==1)?'Desativar':'Ativar' }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                {{-- MODAL STATUS USUARIO --}}
                
		    @endforeach
		</div>
	</div>
</div>



{{-- MODAL CRIA USUARIO --}}
<div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel33">Novo usuário</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form action="{{ url('/usuarios') }}" method="POST">
                @csrf
                <div class="modal-body">
	                <div class="font-small-3">
                    	<i class="feather icon-alert-triangle text-warning"></i>&nbsp;<span class="text-danger">Nesta área são criados usuários administrativos apenas!!</span>
                    </div>

                    <input type="hidden" name="client_id" value="0">
                    
                    <label>Nome: </label>
                    <div class="form-group">
                        <input type="text" name="name" placeholder="Nome" class="form-control">
                    </div>

                    <label>Email: </label>
                    <div class="form-group">
                        <input type="text" name="email" placeholder="Email Address" class="form-control">
                    </div>
                    <div class="font-small-3">
                    	<i class="feather icon-alert-triangle text-warning"></i>&nbsp;<span class="text-danger">Uma senha será gerada e enviada para o email.</span>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- MODAL CRIA USUARIO --}}

@endsection
