@extends('layouts.authenticated')

@section('extrajs')
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Testes</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">

            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Testes de Desenvolvimento</h4>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h7><br></h7>
                                <h5>Interrupção <span class="text-uppercase text-danger">DD</span> no código</h5>
                                <h7><b>Descrição: </b>Testes de variáveis internas do sistema.</h7>
                            </div>
                        </div>
                        <div class="row justify-content-end">
                            <form action="{{ url('/testes/testedd') }}" method="post" >
                                @csrf
                                <select name="acao" id="acao" class="form-control">
                                    <option value="dd_application_log">Log da Aplicação</option>
                                    <option value="dd_info_sessao">Informações da sessão</option>
                                </select>
                                <br>
                                <button type="submit" name="" class="btn btn-info mr-1 mb-1 waves-effect waves-light">Executar rotina</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h7><br></h7>
                                <h5>MÉTODOS DE <span class="text-uppercase text-danger">CLIENTE SPS</span></h5>
                                <h7><b>Descrição: </b>Testes internos referentes a nova classe de ClienteSPS.</h7>
                            </div>
                        </div>
                        <div class="row  justify-content-end">
                            <form action="{{ url('/testes/clientesps') }}" method="get" >
                                @csrf
                                <button type="submit" name="" class="btn btn-info mr-1 mb-1 waves-effect waves-light">Executar rotina</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h7><br></h7>
                                <h5 class="text-uppercase">Pagamento Unificado</h5>
                                <h7><b>Descrição: </b>O sistema simulará o lançamento das mensalidades, distribuição, provisionamento, cálculo de taxas e pagamento de limites utilizados.</h7>
                            </div>
                        </div>
                        <div class="row  justify-content-end">
                            <form action="{{ route('testes.pagamento-unificado') }}" method="get" >
                                @csrf
                                <button type="submit" name="submit" class="btn btn-info mr-1 mb-1 waves-effect waves-light">Ir para Teste</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h5 class="text-uppercase mt-1">D+0 e D+1 Automático</h5>
                                <b>Descrição: </b>O sistema testará, por etapas controladas pelo usuário, a rotina de D+0 e D+1 automático.
                            </div>
                        </div>
                        <div class="row  justify-content-end">
                            <form action="{{ route('testes.d0automatico') }}" method="get">
                                @csrf
                                <button type="submit" id="btn-lancar-mensalidades" name="" class="btn btn-info mr-1 mb-1 waves-effect waves-light">Testar D+0 e D+1</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>

@endsection

@section('inlinejs')
<script type="text/javascript">
    $(document).ready(() => {

        // let retornoLancarMensalidades = {!! (isset($dadosView)) ? json_encode($dadosView->toArray()) : 'false' !!};
        let retornoLancarMensalidades = '{!! session("scrollTo") !!}';
        console.log(retornoLancarMensalidades);
        if (retornoLancarMensalidades) {
            console.log('sim');
            console.log(retornoLancarMensalidades);
        } else {
            console.log('não');
        }
    })

    function exibirCarregando() {
        $("#btn-lancar-mensalidades")
            .attr('disabled', true)
            .html('<i class="fa fa-spinner fa-spin fa-fw"></i>Processando...')
            .removeClass('btn-primary')
            .addClass('btn-danger');

        return true;
    }
</script>
@endsection
