@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>PAGAMENTO UNIFICADO</h2>
        </div>
    </div>

    @if(empty(json_decode($dadosClientes)))
        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">
                <div class="card">
                    <div class="card-body">
                        <h4>Atualmente não há clientes com mensalidades lançadas no banco de dados.</h4>
                        <p>Clique em <span class="text-warning">LANÇAR MENSALIDADES</span> para atualizar.</p>
                    </div>
                </div>
            </div>
        </div>
    @else
        @foreach(json_decode($dadosClientes) as $cliente)
            <div class="row justify-content-md-center">
                <div class="col-md-8 col-12">
                    <div class="card" data-taxnumber="{{ $cliente->taxnumber }}">

                        <form action="{{ route('testes.distribuicao.efetuar') }}" method="post" onsubmit="handleClick(this)">

                            <div class="card-body">
                                <h4 class="mt-2">{{ $cliente->name }}</h4>
                                <div class="d-flex justify-content-start align-items-center mb-1">
                                    <div class="mr-auto user-like"><b>CNPJ/CPF:</b> {{ formataCNPJ($cliente->taxnumber) }}</div>
                                    <div class="ml-auto user-like">
                                        <div id="divSaldoCliente">
                                            <strong>Saldo Real:</strong>
                                            <span id="valorSaldoCliente"></span>
                                            <button type="button" id="btnSaldoCliente" class="btn btn-link" onclick="buscarSaldoCliente(this)"><i class="fa fa-refresh" aria-hidden="true"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="card-content">
                                <div class="card-body">
                                    <div class="row justify-content-end">
                                        <div class="col-12 text-right">
                                            <div class="form-group row">

                                                <label for="valorAdiantamento" class="col-sm-5 col-form-label">Σ (Adiantamento + Saldo Devedor + Provisionamento)</label>
                                                <div class="col-sm-6">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="basic-addon1">R$</span>
                                                        </div>
                                                        <input type="text" id="valorAdiantamento" class="form-control valor" name = "valorAdiantamento" value="{{ formatMoneyBr($cliente->valorAdiantamento) }}" disabled>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="taxa" class="col-sm-5 col-form-label">Σ Taxas a Cobrar</label>
                                                <div class="col-sm-6">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="basic-addon1">R$</span>
                                                        </div>
                                                        <input type="text" id="taxa" class="form-control valor" name = "taxa" value="{{ formatMoneyBr($cliente->taxa) }}" disabled>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="form-group row">
                                                <label for="saldoACompensar" class="col-sm-5 col-form-label">Saldo a Compensar</label>
                                                <div class="col-sm-6">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="basic-addon1">R$</span>
                                                        </div>
                                                        <input type="text" id="saldoACompensar" class="form-control valor" name = "saldoACompensar" value="{{ formatMoneyBr($cliente->saldoACompensar) }}" disabled>
                                                    </div>
                                                </div>
                                            </div>

                                            <hr />

                                            <div class="form-group row">

                                                <input type="hidden" id="taxnumber" class="form-control valor" name="taxnumber_distribuicao" value="{{ $cliente->taxnumber }}">
                                                <label for="distribuicao" class="col-sm-5 col-form-label">Distribuir</label>
                                                <div class="col-sm-6">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span class="input-group-text" id="basic-addon1">R$</span>
                                                        </div>
                                                        <input type="text" id="distribuicao" class="form-control valor" name="valor_distribuicao" value="{{ formatMoneyBr(0) }}">
                                                        <div class="input-group-append">
                                                            @csrf
                                                            <button class="btn btn-outline-primary" data-taxnumber="{{ $cliente->taxnumber }}" type="submit" id="btn-enviar-distribuicao">ENVIAR</button>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </form>

                    </div>{{-- card --}}
                </div>{{-- col-8 --}}
            </div>{{-- row --}}
        @endforeach
    @endif
</div>

<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
                <div class="card-body p-2">
                    <div class="row">
                        <div class="col-sm-12">
                            <p class="ml-2">Botões para testes das rotinas que acontecem <strong>no início do dia</strong></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <form action="{{ route('testes.mensalidades.lancar') }}" method="post" onsubmit="handleClick(this)">
                                @csrf
                                <button type="submit" class="btn btn-block btn-primary waves-effect waves-light">LANÇAR MENSALIDADES</button>
                            </form>
                        </div>
                        <div class="col-sm-6">
                            <form action="{{ route('testes.mensalidades.pagar') }}" method="post" onsubmit="handleClick(this)">
                                @csrf
                                <button type="submit" class="btn btn-block btn-primary waves-effect waves-light">PAGAR MENSALIDADES</button>
                            </form>
                        </div>
                    </div>

                     <hr class="my-3" />

                    <div class="row">
                        <div class="col-sm-12">
                            <p class="ml-2">Botões para testes das rotinas que acontecem <strong>no término do dia</strong></p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-4">
                            <form action="{{ route('testes.limites-utilizados.pagar') }}" method="post" onsubmit="handleClick(this)">
                                @csrf
                                <button type="submit" class="btn btn-block btn-primary waves-effect waves-light">PAGAR LIMITES UTILIZADOS</button>
                            </form>
                        </div>
                        <div class="col-sm-4">
                            <form action="{{ route('testes.limites-utilizados.calcular-taxas') }}" method="post" onsubmit="handleClick(this)">
                                @csrf
                                <button type="submit" class="btn btn-block btn-primary waves-effect waves-light">CALCULAR TAXAS</button>
                            </form>
                        </div>
                        <div class="col-sm-4">
                            <form action="{{ route('testes.limites-utilizados.cobrar-taxas') }}" method="post" onsubmit="handleClick(this)">
                                @csrf
                                <button type="submit" class="btn btn-block btn-primary waves-effect waves-light">COBRAR TAXAS</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('.valor').maskMoney({
                prefix:'',
                allowNegative: false,
                thousands:'.',
                decimal:',',
                affixesStay: false
            });
        });

        function handleClick(el) {
            const btn = el.querySelector('.btn[type=submit]')
            btn.setAttribute('disabled', 'disabled')
            btn.classList.add('disabled')
            btn.innerHTML = '<i class="fa fa-spinner fa-spin fa-fw"></i>&nbsp;Processando...'
            return true
        }

        function buscarSaldoCliente(el) {
            let cliente = $(el).closest(".card").data('taxnumber');
            let cardCliente = $(el).closest(".card");

            cardCliente.find('#btnSaldoCliente i').addClass('fa-spin');
            cardCliente.find('#btnSaldoCliente').prop('disabled', true);
            $.get(
                "{{ route('testes.mensalidades.buscarsaldocliente') }}",
                {
                    _token: "{{ csrf_token() }}",
                    cliente
                },
                (res) => {
                    cardCliente.find('#btnSaldoCliente i').removeClass('fa-spin');
                    cardCliente.find('#btnSaldoCliente').prop('disabled', false);
                    cardCliente.find('#valorSaldoCliente').text(res)
                },
                'JSON'
            )
        }

        console.table(JSON.parse(`{!! $dadosClientes !!}`))
    </script>
@endsection
