@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-10 col-12 text-right my-2">
            <h2>D+0 E D+1 AUTOMÁTICO</h2>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-10 col-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="my-2">Rotina de Agendamento de D+0 e D+1 Automático</h4>
                    <p>
                        Clique no botão abaixo para testar a rotina que efetua o agendamento do D+0 e D+1 automático para os clientes que estão com esta funcionalidade habilitada.
                    </p>
                    <div class="row">
                        <form action="{{ route('testes.d0automatico.agendar') }}" method="POST" class="col-3 mb-2">
                            @csrf
                            <button type="submit" class="btn btn-block btn-success waves-effect waves-light">Agendar D+0 e D+1</button>
                        </form>
                        <a href="{{ route('clientes') }}" class="col-3 btn btn-link">Gerenciar Clientes</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-10 col-12 my-2">
            <div class="card">
                <div class="card-body pb-2">
                    <h4 class="my-2">Clientes com D+0 habilitado</h4>
                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#listaClientesD0Habilitados" aria-expanded="false" aria-controls="listaClientesD0Habilitados">
                        Clique aqui para ver a lista dos clientes habilitados
                    </button>
                    <div class="collapse" id="listaClientesD0Habilitados">
                        <div class="card card-body">
                            <table class="table">
                                @if (count($arrayClientesD0Habilitados) > 0)
                                    <thead>
                                        <th>CPF/CNPJ</th>
                                        <th>Nome</th>
                                        <th>Horário Desejado</th>
                                    </thead>
                                    @foreach ($arrayClientesD0Habilitados as $cliente)
                                        <tr>
                                            <td>
                                                {{ formataCNPJ($cliente['taxnumber']) }}
                                            </td>
                                            <td>
                                                {{ $cliente['name'] }}
                                            </td>
                                            <td>
                                                {{ $cliente['d0time'] }}
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="3">Não há clientes habilitados.</td>
                                    </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-10 col-12 my-2">
            <div class="card">
                <div class="card-body pb-2">
                    <h4 class="my-2">Clientes com D+1 habilitado</h4>
                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#listaClientesD1Habilitados" aria-expanded="false" aria-controls="listaClientesD1Habilitados">
                        Clique aqui para ver a lista dos clientes habilitados
                    </button>
                    <div class="collapse" id="listaClientesD1Habilitados">
                        <div class="card card-body">
                            <table class="table">
                                @if (count($arrayClientesD1Habilitados) > 0)
                                    <thead>
                                        <th>CPF/CNPJ</th>
                                        <th>Nome</th>
                                        <th>Horário Desejado</th>
                                    </thead>
                                    @foreach ($arrayClientesD1Habilitados as $cliente)
                                        <tr>
                                            <td>
                                                {{ formataCNPJ($cliente['taxnumber']) }}
                                            </td>
                                            <td>
                                                {{ $cliente['name'] }}
                                            </td>
                                            <td>
                                                {{ $cliente['d1time'] }}
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="3">Não há clientes habilitados.</td>
                                    </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-10 col-12">
            <h3 class="my-2">D+0 Automático Agendados</h3>
            @if (count($arrayAgendamentosD0) > 0)
                @foreach ($arrayAgendamentosD0 as $cliente)
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-2">{{ $cliente['name'] }}</h4>
                            <div class="d-flex justify-content-start align-items-center mb-1">
                                <div class="mr-auto user-like"><b>CNPJ/CPF:</b> {{ formataCNPJ($cliente['taxnumber']) }}</div>
                            </div>
                            @if (count($cliente['todosAgendamentosD0Cliente']) > 0)
                                <table class="table table-hover">
                                    <thead>
                                        <th>Data/Hora</th>
                                        <th>Status</th>
                                        <th>Valor</th>
                                        <th>Retorno</th>
                                        <th>Validação</th>
                                    </thead>
                                    <tbody>
                                        @foreach ($cliente['todosAgendamentosD0Cliente'] as $agendamento)
                                            <tr>
                                                <td>
                                                    {{ datetime2br($agendamento['scheduleddatetime']) }}
                                                </td>
                                                <td>{{ $agendamento['operationstatus'] }}</td>
                                                <td>{{ ($agendamento['operationvalue']) ? formatMoneyBr($agendamento['operationvalue']) : '-' }}</td>
                                                <td>{{ ($agendamento['operationresponse']) ? $agendamento['operationresponse'] : '-' }}</td>
                                                <td>
                                                    <div class="d-flex justify-content-between">
                                                        {{-- <form action="{{ route('testes.d0automatico.autorizar', $agendamento['id_agendamento']) }}" method="POST">
                                                            @csrf
                                                            <button type="submit" class="btn btn-outline-success">Autorizar</button>
                                                        </form> --}}
                                                        @if ($agendamento['operationstatus'] == 'AGENDADO')
                                                            <form action="{{ route('testes.d0automatico.cancelar', $agendamento['id_agendamento']) }}" method="POST">
                                                                @csrf
                                                                <input type="hidden" name="id_agendamento" value="{{ $agendamento['id_agendamento'] }}">
                                                                <button type="submit" class="btn btn-outline-danger">Cancelar</button>
                                                            </form>
                                                        @elseif ($agendamento['operationstatus'] == 'CANCELADO')
                                                            -
                                                            {{-- <form action="{{ route('testes.d0automatico.desfazer-cancelamento', $agendamento['id_agendamento']) }}" method="POST">
                                                                @csrf
                                                                <input type="hidden" name="id_agendamento" value="{{ $agendamento['id_agendamento'] }}">
                                                                <button type="submit" class="btn btn-outline-success">Desfazer</button>
                                                            </form> --}}
                                                        @else
                                                            -
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                            @else
                                <p>Cliente habilitado porém não há agendamentos.</p>
                            @endif
                        </div>
                    </div>
                @endforeach

            @else
                <p>Não há agendamentos.</p>
            @endif

            <h3 class="my-2 mt-4">D+1 Automático Agendados</h3>
            @if (count($arrayAgendamentosD1) > 0)
                @foreach ($arrayAgendamentosD1 as $cliente)
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-2">{{ $cliente['name'] }}</h4>
                            <div class="d-flex justify-content-start align-items-center mb-1">
                                <div class="mr-auto user-like"><b>CNPJ/CPF:</b> {{ formataCNPJ($cliente['taxnumber']) }}</div>
                            </div>
                            @if (count($cliente['todosAgendamentosD1Cliente']) > 0)
                                <table class="table table-hover">
                                    <thead>
                                        <th>Data/Hora</th>
                                        <th>Status</th>
                                        <th>Valor</th>
                                        <th>Retorno</th>
                                        <th>Validação</th>
                                    </thead>
                                    <tbody>
                                        @foreach ($cliente['todosAgendamentosD1Cliente'] as $agendamento)
                                            <tr>
                                                <td>
                                                    {{ datetime2br($agendamento['scheduleddatetime']) }}
                                                </td>
                                                <td>{{ $agendamento['operationstatus'] }}</td>
                                                <td>{{ ($agendamento['operationvalue']) ? formatMoneyBr($agendamento['operationvalue']) : '-' }}</td>
                                                <td>{{ ($agendamento['operationresponse']) ? $agendamento['operationresponse'] : '-' }}</td>
                                                <td>
                                                    <div class="d-flex justify-content-between">
                                                        {{-- <form action="{{ route('testes.d0automatico.autorizar', $agendamento['id_agendamento']) }}" method="POST">
                                                            @csrf
                                                            <button type="submit" class="btn btn-outline-success">Autorizar</button>
                                                        </form> --}}
                                                        @if ($agendamento['operationstatus'] == 'AGENDADO')
                                                            <form action="{{ route('testes.d0automatico.cancelar', $agendamento['id_agendamento']) }}" method="POST">
                                                                @csrf
                                                                <input type="hidden" name="id_agendamento" value="{{ $agendamento['id_agendamento'] }}">
                                                                <button type="submit" class="btn btn-outline-danger">Cancelar</button>
                                                            </form>
                                                        @elseif ($agendamento['operationstatus'] == 'CANCELADO')
                                                            -
                                                            {{-- <form action="{{ route('testes.d0automatico.desfazer-cancelamento', $agendamento['id_agendamento']) }}" method="POST">
                                                                @csrf
                                                                <input type="hidden" name="id_agendamento" value="{{ $agendamento['id_agendamento'] }}">
                                                                <button type="submit" class="btn btn-outline-success">Desfazer</button>
                                                            </form> --}}
                                                        @else
                                                            -
                                                        @endif
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                            @else
                                <p>Cliente habilitado porém não há agendamentos.</p>
                            @endif
                        </div>
                    </div>
                @endforeach

            @else
                <p>Não há agendamentos.</p>
            @endif

            <div class="card mt-4">
                <div class="card-body py-2">
                    <h3>Executar D+0 e D+1 Automático</h3>
                    <p>Clique no botão abaixo para executar o D+0 e D+1 automaticamente para todos os agendamentos acima.</p>
                    <form action="{{ route('testes.d0automatico.autorizar') }}" method="POST">
                        @csrf
                        <button type="submit" class="btn btn-success waves-effect waves-light">Executar D+0 e D+1 Automático</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
