@extends('layouts.authenticated')

@section('extrajs')
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Testes para classe ClienteSSG</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">

            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Testes de Desenvolvimento</h4>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <br>
                        <form action="{{ url('/testes/clientesps') }}" method="POST">
                            @csrf
                            <div class="form-body">
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span>Cliente</span>
                                            </div>
                                            <div class="col-md-8">
                                                <select id="taxnumber" class="form-control" name="taxnumber">
                                                    <option value="0"> - Selecione - </option>
                                                    @foreach($clients as $client)
                                                        <option value="{{ $client->taxnumber }}">{{ $client->name }} &nbsp;&nbsp;[R$ {{ formatMoneyBr($client->availablelimit) }}]</option>

                                                        @foreach($client->multiconta as $multi)
                                                            <option value="{{ $multi->taxnumber }}"> - {{ $multi->nickname }} &nbsp;&nbsp;[R$ {{ formatMoneyBr($multi->availablelimit) }}]</option>
                                                        @endforeach

                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                &nbsp;
                                            </div>
                                            <div class="custom-control custom-checkbox col-md-8">
                                                <input type="checkbox" class="custom-control-input" checked="" name="limiteespecial" id="limiteespecial" value="1">
                                                <label class="custom-control-label" for="limiteespecial">Permitir utilização do saldo a compensar (**)</label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <div class="form-group row">
                                            <div class="col-md-4">
                                                <span>Valor</span>
                                            </div>
                                            <div class="col-md-8">
                                                <input type="valor" id="valor" class="form-control" name="valor" placeholder="Valor" value="">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-8 offset-md-4">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Enviar</button>
                                        <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h7><br></h7>
                                <h5>Teste Externo: <span class="text-uppercase text-danger">LIMITE DA OPERAÇÃO</span></h5>
                                <h7><b>Cliente: </b>{{ $infoCliente['nomeCliente'] }}</h7><br>
                                <h7><b>Client ID: </b>{{ $infoCliente['clientId'] }}</h7><br>
                                <h7><b>Saldo real: </b>{{ $infoCliente['saldoReal'] }}</h7><br>
                                <h7><b>Saldo a compensar: </b>{{ $infoCliente['saldoCompensar'] }}</h7><br>
                                <h7><b>Usar saldo a compensar: </b>
                                    {{ $limiteEspecial }}</h7><br>
                                <h7><b>Limite para <span class="text-uppercase text-danger">BOLETOS</span>: </b>{{ $limiteOperacao['boleto'] }}</h7><br>
                                <h7><b>Limite para <span class="text-uppercase text-danger">TRANSFERÊNCIA EXTERNA</span>: </b>{{ $limiteOperacao['transferenciaExterna'] }}</h7><br>
                                <h7><b>Limite para <span class="text-uppercase text-danger">TRANSFERÊNCIA INTERNA</span>: </b>{{ $limiteOperacao['transferenciaInterna'] }}</h7><br>
                                <h7><b>Limite para <span class="text-uppercase text-danger">DX AUTOMÁTICO</span>: </b>{{ $limiteOperacao['dxAutomatico'] }}</h7><br>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h7><br></h7>
                                <h5>Teste Externo: <span class="text-uppercase text-danger">VALOR A ADIANTAR</span></h5>
                                <h7><b>Cliente: </b>{{ $infoCliente['nomeCliente'] }}</h7><br>
                                <h7><b>Client ID: </b>{{ $infoCliente['clientId'] }}</h7><br>
                                <h7><b>Saldo real: </b>{{ $infoCliente['saldoReal'] }}</h7><br>
                                <h7><b>Valor total da operaçao: </b>{{ $infoCliente['valorOperacao'] }}</h7><br>
                                <h7><b>Adiantamento para <span class="text-uppercase text-danger">BOLETOS</span>: </b><br>
                                Valor = {{ $adiantar['boleto'] }},  txOperacao = {{ $adiantar['txOperacaoBoleto'] }} e TxAdiantamento = {{ $adiantar['taxaBoleto'] }}</h7><br>
                                <h7><b>Adiantamento para <span class="text-uppercase text-danger">TRANSFERÊNCIA EXTERNA</span>: </b><br>
                                Valor: {{ $adiantar['transferenciaExterna'] }},  txOperacao = {{ $adiantar['txOperacaoTransferenciaExterna'] }} e TxAdiantamento = {{ $adiantar['taxaTransferenciaExterna'] }}</h7><br>
                                <h7><b>Adiantamento para <span class="text-uppercase text-danger">TRANSFERÊNCIA INTERNA</span>: </b><br>
                                Valor: {{ $adiantar['transferenciaInterna'] }},  txOperacao = {{ $adiantar['txOperacaoTransferenciaInterna'] }} e TxAdiantamento = {{ $adiantar['taxaTransferenciaInterna'] }}</h7><br>
                                <h7><b>Adiantamento para <span class="text-uppercase text-danger">DX AUTOMÁTICO</span>: </b><br>
                                Valor: {{ $adiantar['dxAutomatico'] }},  txOperacao = {{ $adiantar['txOperacaoDxAutomatico'] }} e TxAdiantamento = {{ $adiantar['taxaDxAutomatico'] }}</h7><br>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h7><br></h7>
                                <h5><span class="text-uppercase text-danger">TESTE INTERNO</span> Resultado em formato <span class="text-uppercase text-danger">JSON</span></h5>
                                <h7><b>Valor: </b>{{ $json }}</h7>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>

@endsection

@section('inlinejs')
@endsection
