@extends('layouts.authenticated')

@section('extrajs')
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Transferência - Detalhada</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 text-right"><strong>Saldo SPS: R$ {{ $saldoSps }}</strong></div>
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>    

        @foreach($clients as $cli)
            <div class="row justify-content-md-center">
                <div class="col-md-8 col-12">    
                    <div class="card">
                        <!-- CARD HEADER -->
                        <div class="card-body">
                        <div class="d-flex justify-content-start align-items-center mb-1">
                                <h4>{{ $cli->name }} <span class="text-muted">[{{ formataCNPJ($cli->taxnumber) }}]</span></h4>
                        </div>
                        </div>
                        <!-- /CARD HEADER -->
                        <div class="card-content">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4  offset-md-8 text-right">
                                        
                                        <form action="{{ url('/transferencia-visao-geral') }}" method="POST">
                                            @csrf
                                            <input type="hidden" name="client_id" value="{{ $cli->id }}">
                                            <div class="formgroup row">
                                                <div class="col-lg-12 col-12">
                                                    <button type="submit" class="btn btn-primary btn-block" value="Transferir">Ver detalhes</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>{{-- card --}}
                </div>{{-- col-8 --}}
            </div>{{-- row --}}
        @endforeach
</div>

@endsection

@section('inlinejs')
@endsection
