@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Transferência - Detalhada</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 text-right"><strong>Saldo SPS: R$ {{ $saldoSps }}</strong></div>
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>    

        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <!-- CARD HEADER -->
                    <div class="card-body">
                    <div class="d-flex justify-content-start align-items-center mb-1">
                            <h4>{{ $client->name }} <span class="text-muted">[{{ formataCNPJ($client->taxnumber) }}]</span></h4>
                    </div>
                    </div>
                    <!-- /CARD HEADER -->
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    @if(empty($ultimasmovimentacoes))

                                        <h3>Problema ao consultar</h3>

                                        <p>- Certifique-se de que o cliente existe na Smartsafe e que o CNPJ está correto.</p>

                                        <p>- Se você nunca realizou transferência para esse cliente, primeiro deve fazer uma transferência para que o sistema possua uma referência.</p>

                                    @else
                                        <table class="table table-striped table-bordered">
                                            <thead>
                                                <th>Data</th>
                                                <th>Terminal</th>
                                                <th>Operação</th>
                                                <th>Valor Válido <sup class="text-danger ">(*)</sup> </th>
                                            </thead>
                                            <tbody>
                                                <?php $totaltransf = 0;?>
                                                @foreach($ultimasmovimentacoes as $mov)
                                                    <tr>
                                                        <td>{{ $mov['emission'] }}</td>
                                                        <td>{{ $mov['terminal'] }}</td>
                                                        <td class="{{ (($mov['tipomovimentacao']=='COLETA')?'text-info':'text-success') }}">{{ $mov['tipomovimentacao'] }}</td>
                                                        <td>R$ {{ formatMoneyBr($mov['totalcedulas']) }}</td>
                                                    </tr>
                                                    <?php $totaltransf += $mov['totalcedulas'];?>
                                                @endforeach
                                                <?php updateAvailableLimit($client->id, $totaltransf) ?>
                                                <tr>
                                                    <td colspan="3" class="text-right">Total</td>
                                                    <td>R$ {{ formatMoneyBr($totaltransf) }}</td>
                                                </tr>
                                                <tr>
                                                    <td colspan="4" class="text-center text-small">
                                                        (*) O montante válido corresponde apenas aos valos em espécie. Não considerando depósitos em envelopes
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>

                                        <div class="row">
                                            <div class="col-md-8 offset-md-4">
                                                <form action="{{ url('/transferenciacliente') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="client_id" value="{{ $client->id }}">
                                                    <div class="row justify-content-end">
                                                        <div class="formgroup row">
                                                            <div class="col-lg-5 col-12 input-group">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text">R$</span>
                                                                </div>
                                                                <input type="text" id="valor" class="form-control valor" name="valor" value="{{formatMoneyBr($totaltransf)}}" style="display: inline-block;">
                                                            </div>
                                                            <div class="col-lg-7 col-12">
                                                                <button type="submit" class="btn btn-primary btn-block" value="Transferir">Transferir para o cliente</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>{{-- card --}}
            </div>{{-- col-8 --}}
        </div>{{-- row --}}
    
</div>

@endsection

@section('inlinejs')
<script type="text/javascript">
    $(function() {
        $('.valor').maskMoney({
            prefix:'', 
            allowNegative: false, 
            thousands:'.', 
            decimal:',', 
            affixesStay: false
        });
    });
</script>
@endsection
