@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Relatório - Gráficos</h2>
        </div>
    </div>
    <div class="row justify-content-md-center no-print">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($filtros['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($filtros['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <select name="client_id" class="form-control">
                                        <option value="">Todos</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ ($filtros['filtroCliente'] == $client->id )?'selected':'' }}>{{ $client->name }}</option>
                                        @endforeach
                                    </select>

                                    <input type="hidden" name="mensalidade" value="1">
                                </div>
                            </div>
                            
                        </div>{{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ ($filtros['datade']) }} a {{ ($filtros['dataate']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Column Chart -->
                        <div class="col-lg-8 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Geral</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <div id="column-chart"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Total</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <?php $totalFit = $relatorio['darf']['fitvalue']+
                                                    $relatorio['darj']['fitvalue']+
                                                    $relatorio['fgts']['fitvalue']+
                                                    $relatorio['gps']['fitvalue']+
                                                    $relatorio['gare']['fitvalue']+
                                                    $relatorio['barcodepayment']['fitvalue']+
                                                    $relatorio['transfer']['fitvalue']+
                                                    $relatorio['billets']['fitvalue']+
                                                    $relatorio['monthlyfee']['fitvalue']+
                                                    $relatorio['availablelimit']['fitvalue'];

                                                $totalCli = $relatorio['darf']['totalvalue']+
                                                    $relatorio['darj']['totalvalue']+
                                                    $relatorio['fgts']['totalvalue']+
                                                    $relatorio['gps']['totalvalue']+
                                                    $relatorio['gare']['totalvalue']+
                                                    $relatorio['barcodepayment']['totalvalue']+
                                                    $relatorio['transfer']['totalvalue']+
                                                    $relatorio['billets']['totalvalue']+
                                                    $relatorio['monthlyfee']['totalvalue']+
                                                    $relatorio['availablelimit']['totalvalue'];
                                        ?>

                                        <p>FitBank: <b class="text-danger">R$ {{ $totalFit }}</b></p>
                                        <p>Clientes: <b class="text-info">R$ {{ $totalCli }}</b></p>
                                        <hr>
                                        <b class="{{ (($totalFit+$totalCli)>=0)?'text-success':'text-danger' }} pull-right">R$ {{ $totalFit+$totalCli }}</b>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }

        // Column Chart
        // ----------------------------------
        var $primary = '#7367F0',
            $success = '#28C76F',
            $danger = '#EA5455',
            $warning = '#FF9F43',
            $info = '#00cfe8',
            $label_color_light = '#dae1e7';

        var themeColors = [$danger, $success, $primary, $warning, $info];

        // RTL Support
        var yaxis_opposite = false;
        if($('html').data('textdirection') == 'rtl'){
            yaxis_opposite = true;
        }

        var columnChartOptions = {
            chart: {
              height: 450,
              type: 'bar',
            },
            colors: themeColors,
            plotOptions: {
              bar: {
                horizontal: false,
                endingShape: 'rounded',
                columnWidth: '55%',
              },
            },
            dataLabels: {
              enabled: false
            },
            stroke: {
              show: true,
              width: 2,
              colors: ['transparent']
            },
            series: [{
              name: 'FitBank',
              data: [
                {{ $relatorio['darf']['fitvalue'] }},
                {{ $relatorio['darj']['fitvalue'] }},
                {{ $relatorio['fgts']['fitvalue'] }},
                {{ $relatorio['gps']['fitvalue'] }},
                {{ $relatorio['gare']['fitvalue'] }},
                {{ $relatorio['barcodepayment']['fitvalue'] }},
                {{ $relatorio['transfer']['fitvalue'] }},
                {{ $relatorio['billets']['fitvalue'] }},
                {{ $relatorio['monthlyfee']['fitvalue'] }},
                {{ $relatorio['availablelimit']['fitvalue'] }}
              ]
            }, {
              name: 'Cliente',
              data: [
                {{ $relatorio['darf']['totalvalue'] }},
                {{ $relatorio['darj']['totalvalue'] }},
                {{ $relatorio['fgts']['totalvalue'] }},
                {{ $relatorio['gps']['totalvalue'] }},
                {{ $relatorio['gare']['totalvalue'] }},
                {{ $relatorio['barcodepayment']['totalvalue'] }},
                {{ $relatorio['transfer']['totalvalue'] }},
                {{ $relatorio['billets']['totalvalue'] }},
                {{ $relatorio['monthlyfee']['totalvalue'] }},
                {{ $relatorio['availablelimit']['totalvalue'] }},
              ]
            }],
            legend: {
              offsetY: -10
            },
            xaxis: {
              // categories: ['Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
              categories: [
                'DARF',
                'DARJ',
                'FGTS',
                'GPS',
                'GARE',
                'Cod. Barras',
                'Transf.',
                'Boletos',
                'Mensalidade',
                'Lim. Disp.',
              ],
            },
            yaxis: {
              title: {
                text: 'R$'
              },
              opposite: yaxis_opposite
            },
            fill: {
              opacity: 1

            },
            tooltip: {
              y: {
                formatter: function (val) {
                  return "R$ " + val
                }
              }
            }
          }
          var columnChart = new ApexCharts(
            document.querySelector("#column-chart"),
            columnChartOptions
          );

          columnChart.render();
    </script>
@endsection

