@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Relatório Anual</h2>
        </div>
    </div>
    <div class="row justify-content-md-center no-print">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    
                    <?php $anoatual = date('Y')?>
                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Selecione o ano
                                </div>
                                <div class="col-md-8">
                                    <select name="filtroano" class="form-control col-md-5">
                                        <option value="{{ $anoatual }}"   {{ ($filtros['filtroano'] == $anoatual)?'selected':'' }}>{{ $anoatual }}</option>
                                        <option value="{{ $anoatual-1 }}" {{ ($filtros['filtroano'] == $anoatual-1)?'selected':'' }}>{{ $anoatual-1 }}</option>
                                        <option value="{{ $anoatual-2 }}" {{ ($filtros['filtroano'] == $anoatual-2)?'selected':'' }}>{{ $anoatual-2 }}</option>
                                        <option value="{{ $anoatual-3 }}" {{ ($filtros['filtroano'] == $anoatual-3)?'selected':'' }}>{{ $anoatual-3 }}</option>
                                        <option value="{{ $anoatual-4 }}" {{ ($filtros['filtroano'] == $anoatual-4)?'selected':'' }}>{{ $anoatual-4 }}</option>
                                        
                                    </select>
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <select name="client_id" class="form-control">
                                        <option value="">Todos</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ ($filtros['filtroCliente'] == $client->id )?'selected':'' }}>{{ $client->name }}</option>
                                        @endforeach
                                    </select>

                                    <input type="hidden" name="mensalidade" value="1">
                                </div>
                            </div>
                            
                        </div>{{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Ano: {{ ($filtros['filtroano']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Line Chart -->
                        <div class="col-lg-12 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Geral</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <div id="line-chart"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Total</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <?php $totalFit = $relatorio['01']['totalFitbank']+
                                                          $relatorio['02']['totalFitbank']+
                                                          $relatorio['03']['totalFitbank']+
                                                          $relatorio['04']['totalFitbank']+
                                                          $relatorio['05']['totalFitbank']+
                                                          $relatorio['06']['totalFitbank']+
                                                          $relatorio['07']['totalFitbank']+
                                                          $relatorio['08']['totalFitbank']+
                                                          $relatorio['09']['totalFitbank']+
                                                          $relatorio['10']['totalFitbank']+
                                                          $relatorio['11']['totalFitbank']+
                                                          $relatorio['12']['totalFitbank'];

                                              $totalCli = $relatorio['01']['totalClientes']+
                                                          $relatorio['02']['totalClientes']+
                                                          $relatorio['03']['totalClientes']+
                                                          $relatorio['04']['totalClientes']+
                                                          $relatorio['05']['totalClientes']+
                                                          $relatorio['06']['totalClientes']+
                                                          $relatorio['07']['totalClientes']+
                                                          $relatorio['08']['totalClientes']+
                                                          $relatorio['09']['totalClientes']+
                                                          $relatorio['10']['totalClientes']+
                                                          $relatorio['11']['totalClientes']+
                                                          $relatorio['12']['totalClientes'];
                                        ?>

                                        <p>FitBank: <b class="text-danger">R$ {{ $totalFit }}</b></p>
                                        <p>Clientes: <b class="text-info">R$ {{ $totalCli }}</b></p>
                                        <hr>
                                        <b class="{{ (($totalFit+$totalCli)>=0)?'text-success':'text-danger' }} pull-right">R$ {{ $totalFit+$totalCli }}</b>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        function validaForm() {
            
            return true;
        }

        // Column Chart
        // ----------------------------------
        var $primary = '#7367F0',
            $success = '#28C76F',
            $danger = '#EA5455',
            $warning = '#FF9F43',
            $info = '#00cfe8',
            $label_color_light = '#dae1e7';

        var themeColors = [$danger, $success, $primary, $warning, $info];

        // RTL Support
        var yaxis_opposite = false;
        if($('html').data('textdirection') == 'rtl'){
            yaxis_opposite = true;
        }

        var lineChartOptions = {
            chart: {
              height: 450,
              type: 'line',
              zoom: {
                enabled: false
              }
            },
            colors: themeColors,
            dataLabels: {
              enabled: false
            },
            stroke: {
              curve: 'straight'
            },
            series: [{
              name: "FitBank",
              data: [
                {{ $relatorio['01']['totalFitbank'] }},
                {{ $relatorio['02']['totalFitbank'] }},
                {{ $relatorio['03']['totalFitbank'] }},
                {{ $relatorio['04']['totalFitbank'] }},
                {{ $relatorio['05']['totalFitbank'] }},
                {{ $relatorio['06']['totalFitbank'] }},
                {{ $relatorio['07']['totalFitbank'] }},
                {{ $relatorio['08']['totalFitbank'] }},
                {{ $relatorio['09']['totalFitbank'] }},
                {{ $relatorio['10']['totalFitbank'] }},
                {{ $relatorio['11']['totalFitbank'] }},
                {{ $relatorio['12']['totalFitbank'] }}
              ],
            },{
              name: "Clientes",
              data: [
                {{ $relatorio['01']['totalClientes'] }},
                {{ $relatorio['02']['totalClientes'] }},
                {{ $relatorio['03']['totalClientes'] }},
                {{ $relatorio['04']['totalClientes'] }},
                {{ $relatorio['05']['totalClientes'] }},
                {{ $relatorio['06']['totalClientes'] }},
                {{ $relatorio['07']['totalClientes'] }},
                {{ $relatorio['08']['totalClientes'] }},
                {{ $relatorio['09']['totalClientes'] }},
                {{ $relatorio['10']['totalClientes'] }},
                {{ $relatorio['11']['totalClientes'] }},
                {{ $relatorio['12']['totalClientes'] }}
              ],
            }],
            title: {
              text: 'Totais mensais (R$)',
              align: 'left'
            },
            grid: {
              row: {
                colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
                opacity: 0.5
              },
            },
            xaxis: {
              categories: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            },
            yaxis: {
              tickAmount: 5,
              opposite: yaxis_opposite
            }
          }
          var lineChart = new ApexCharts(
            document.querySelector("#line-chart"),
            lineChartOptions
          );
          lineChart.render();
    </script>
@endsection

