@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
    {{-- TODO: filtro cliente --}}
    {{-- <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
            <div class="card-body">
                <div class="row">Selecione o período</div>
                <form class="form form-horizontal" onsubmit="validaForm()" method="POST">
                    <div class="row">
                        <div class="col-md-2"></div>
                        <div class="col-md-4">
                            <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" />
                        </div>
                        <div class="col-md-4">
                            <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" />
                        </div>
                            <div class="col-md-2"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                    </div>
                </form>
            </div>
            </div>
        </div>
    </div> --}}
    
    {{-- @if($extrato["Success"] == "false")
        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12 text-danger">
                                Ocorreu um problema ao processar a requisição. Por favor tente novamente mais tarde. <br>
                                <span class="text-muted">{{ $extrato["Message"] }}</span>
                            </div>
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>    

    @else
    --}}
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            <h2>Provisionamento e cobrança de taxas:</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 text-right"><strong>Saldo: R$ {{ formatMoneyBr(getFitbankBalance()) }}</strong></div>
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>    

        @foreach($clients as $cli)
            <div class="row justify-content-md-center">
                <div class="col-md-8 col-12">    
                    <div class="card">
                        <!-- CARD HEADER -->
                        <div class="card-body">
                            <h4>{{ $cli->name }}</h4>
                            <div class="d-flex justify-content-start align-items-center mb-1">
                                <div class="mr-auto user-like"><b>CNPJ/CPF:</b> {{ formataCNPJ($cli->taxnumber) }}</div>
                                <div class="ml-auto user-like"></div>
                            </div>
                        </div>
                        <!-- /CARD HEADER -->
                        <div class="card-content">
                            <div class="card-body">

                                <form action="{{ url('/transferenciaclienterapida') }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="client_id" value="{{ $cli->id }}">
                                    <input type="hidden" name="taxnumber" value="{{ $cli->taxnumber }}">
                                    <div class="row justify-content-end">
                                        <div class="col-12 text-right">
                                            <div class="form-group row">
                                                <label for="saldoDevedor" class="col-sm-5 col-form-label">Adiantamento + Saldo Devedor</label>
                                                <div class="col-sm-4">
                                                  <input type="text" id="saldoDevedor" class="form-control valor" name = "saldoDevedor" value="{{ formatMoneyBr(getAdiantamentoDevido($cli->taxnumber)) }}" disabled>
                                                </div>
                                                <div class="col-sm-3"></div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="saldoDevedor" class="col-sm-5 col-form-label">Taxa a Cobrar</label>
                                                <div class="col-sm-4">
                                                  <input type="text" id="saldoDevedor" class="form-control valor" name = "saldoDevedor" value="{{ formatMoneyBr(getTaxaDevida($cli->taxnumber)) }}" disabled>
                                                </div>
                                                <div class="col-sm-3"></div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>{{-- card --}}
                </div>{{-- col-8 --}}
            </div>{{-- row --}}
        @endforeach

        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <h5>Executar rotina de <span class="text-uppercase text-danger">provisionamento e cobrança</span> de juros por antecipação de limite</h5>
                            </div>
                        </div>
                        <div class="row  justify-content-end">
                            <form action="{{ url('/ferramentas') }}" method="post" >
                                @csrf
                                <input type="hidden" name="acao" value="utilizacaosaldo_cobrarjuros">
                                <input type="submit" name="" class="btn btn-danger mr-1 mb-1 waves-effect waves-light" value="Executar cobrança">
                            </form>    
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>  

    {{-- @endif --}}
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('.valor').maskMoney({
                prefix:'', 
                allowNegative: false, 
                thousands:'.', 
                decimal:',', 
                affixesStay: false
            });
        });

        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection
