@extends('layouts.authenticated')

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title">Configurações</h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">

                        <ul class="nav nav-tabs nav-fill" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="info-tab-fill" data-toggle="tab" href="#info-fill" role="tab" aria-controls="info-fill" aria-selected="false">Informações</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="fitbankrates-tab-fill" data-toggle="tab" href="#fitbankrates-fill" role="tab" aria-controls="fitbankrates-fill" aria-selected="false">Taxas Fitbank</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" id="clientrates-tab-fill" data-toggle="tab" href="#clientrates-fill" role="tab" aria-controls="clientrates-fill" aria-selected="false">Taxas Clientes</a>
                            </li>
                        </ul>

                        <div class="tab-content pt-1">
                            {{-- ABA INFORMAÇÔES --}}
                            <div class="tab-pane active" id="info-fill" role="tabpanel" aria-labelledby="info-tab-fill">
                                <div class="mt-1">
                                <h6 class="mb-0">Nome</h6>
                                <p>{{ $spsinfos->name }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">CNPJ</h6>
                                    <p>{{ formataCNPJ($spsinfos->cnpj) }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Id interno Fitbank - Business Unit Id</h6>
                                    <p>{{ $spsinfos->businessunitid }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Partner Id</h6>
                                    <p>{{ $spsinfos->partnerid }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Key</h6>
                                    <p>{{ $spsinfos->key }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Secret</h6>
                                    <p>{{ $spsinfos->secret }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">MarketPlaceId (Interno Fitbank)</h6>
                                    <p>{{ $spsinfos->mktplaceid }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Email</h6>
                                    <p>{{ $spsinfos->suppliermail }}</p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Telefone</h6>
                                    <p>{{ formataTelefone($spsinfos->supplierphone) }}</p>
                                </div>

                                <br><br>

                                <div class="divider divider-primary">
                                    <div class="divider-text">Informações bancárias</div>
                                </div>

                                <div class="text-right">
                                    <button type="button" class="btn btn-outline-success btn-sm waves-effect waves-light" data-toggle="modal" data-target="#contabanco">
                                        Adicionar Conta
                                    </button>    
                                </div>
                                <br><br>
                                <?php $spsbanks = getSpsBanks($spsinfos->id)?>
                                @foreach($spsbanks as $sb)
                                    <h6>
                                        <i class="fa fa-building-o"></i>&nbsp;&nbsp;{{ $sb->nickname }}
                                        <form action="{{ url('/spsbanks/remove') }}" method="POST" onsubmit="return confirm('Tem certeza?');">
                                            @csrf
                                            <input type="hidden" name="id" value="{{ $sb->id }}">
                                            <span class="pull-right"> <button type="submit" class="btn btn-outline-danger btn-sm waves-effect waves-light">Excluir</button> </span>
                                        </form>
                                    </h6>
                                    <div class="row">
                                        <div class="col-12">
                                            {{ $sb->bankcode .' - '. $sb->bankname }}
                                        </div>
                                        <div class="col-12">
                                            Agência: {{ $sb->bankbranch}}
                                        </div>
                                        <div class="col-12">
                                            Conta: {{ $sb->bankaccount .' - '. $sb->bankaccountdigit }}
                                        </div>
                                        <div class="col-12">
                                            <strong>Tarifas</strong><br>
                                            <span class="paddingl-30">Pagamentos: R$ {{ formatMoneyBr($sb->billpayments) }}</span> <br>
                                            <span class="paddingl-30">Transferências: R$ {{ formatMoneyBr($sb->transfers) }}</span> <br>
                                            <span class="paddingl-30">Geração de boletos: R$ {{ formatMoneyBr($sb->billets) }}</span>
                                        </div>
                                        
                                    </div>

                                    <br>
                                    <br>
                                @endforeach

                                {{-- MODAL NOVA CONTA --}}
                                <div class="modal fade" id="contabanco" tabindex="-1" role="dialog" aria-labelledby="contabancoTitle" aria-modal="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-centered modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalCenterTitle">Adicionar informação bancária</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ url('/spsbanks') }}" method="POST">
                                                    @csrf
                                                    <input type="hidden" name="spsinfo_id" value="{{ $spsinfos->id }}">

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Nome</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="nickname" id="nickname" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Banco</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <?php $banks = getBanks();?>
                                                                <select name="bankname" class="form-control">
                                                                    <option value="0">Selecione</option>
                                                                    @foreach($banks as $bank)
                                                                        <option value="{{ $bank->code.'*'.$bank->name }}">{{ $bank->code .' - '. $bank->name }}</option>}
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Agência</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="bankbranch" id="bankbranch" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Conta</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="bankaccount" id="bankaccount" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Dígito</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="bankaccountdigit" id="bankaccountdigit" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Tx. pagtos</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="billpayments" id="billpayments" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Transferências</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="transfers" id="transfers" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="form-group row">
                                                            <div class="col-md-4">
                                                                <span>Boletos</span>
                                                            </div>
                                                            <div class="col-md-8">
                                                                <input type="text" name="billets" id="billets" class="form-control"/>
                                                            </div>
                                                        </div>
                                                    </div>

                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-outline-dark waves-effect waves-light" data-dismiss="modal">Cancelar</button>
                                                <button type="submit" class="btn btn-success waves-effect waves-light"> Salvar </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- //MODAL NOVA CONTA --}}


                                <div class="divider divider-primary">
                                    <div class="divider-text">Horários limite para transações</div>
                                </div>

                                <br>

                                <div class="mt-1">
                                    <h6>Pagamentos</h6>
                                    <p>{{ $spsinfos->paymentstimelimit }}h</p>
                                </div>

                                <div class="mt-1">
                                    <h6>Transferências</h6>
                                    <p>{{ $spsinfos->transferstimelimit }}h</p>
                                </div>

                                <div class="mt-1">
                                    <h6>Geração de boletos</h6>
                                    <p>{{ $spsinfos->billetstimelimit }}h</p>
                                </div>

                                
                            </div>

                            {{-- ABA TAXAS FITBANK --}}
                            <div class="tab-pane" id="fitbankrates-fill" role="tabpanel" aria-labelledby="fitbankrates-tab-fill">
                               
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <th>Transação</th>
                                        <th class="text-center">Custo</th>
                                        <th class="text-center">Tipo</th>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">Pagamentos</th>
                                            <td class="text-center">{{ ($spsinfos->fitbankpaymentspercentage=='1')?formatMoneyBr($spsinfos->fitbankpayments).'%':'R$ '.formatMoneyBr($spsinfos->fitbankpayments) }}</td>
                                            <td class="text-center">{{ ($spsinfos->fitbankpaymentspercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Transferências (DOC/TED)</th>
                                            <td class="text-center">{{ ($spsinfos->fitbanktransferspercentage=='1')?formatMoneyBr($spsinfos->fitbanktransfers).'%':'R$ '.formatMoneyBr($spsinfos->fitbanktransfers) }}</td>
                                            <td class="text-center">{{ ($spsinfos->fitbanktransferspercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Geração de boletos</th>
                                            <td class="text-center">{{ ($spsinfos->fitbankbilletspercentage=='1')?formatMoneyBr($spsinfos->fitbankbillets).'%':'R$ '.formatMoneyBr($spsinfos->fitbankbillets) }}</td>
                                            <td class="text-center">{{ ($spsinfos->fitbankbilletspercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">P2P</th>
                                            <td class="text-center">{{ ($spsinfos->fitbankp2ppercentage=='1')?formatMoneyBr($spsinfos->fitbankp2p).'%':'R$ '.formatMoneyBr($spsinfos->fitbankp2p) }}</td>
                                            <td class="text-center">{{ ($spsinfos->fitbankp2ppercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Juros por adiantamento de saldo</th>
                                            <td class="text-center">{{ formatMoneyBr($spsinfos->clientbalanceusagedailycharge).'%' }}</td>
                                            <td class="text-center">percentual</td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>

                            {{-- ABA TAXAS DO CLIENTE --}}
                            <div class="tab-pane" id="clientrates-fill" role="tabpanel" aria-labelledby="clientrates-tab-fill">

                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <th>Transação</th>
                                        <th class="text-center">Custo</th>
                                        <th class="text-center">Tipo</th>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">Pagamentos</th>
                                            <td class="text-center">{{ ($spsinfos->clientpaymentspercentage=='1')?formatMoneyBr($spsinfos->clientpayments).'%':'R$ '.formatMoneyBr($spsinfos->clientpayments) }}</td>
                                            <td class="text-center">{{ ($spsinfos->clientpaymentspercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Transferências (DOC/TED)</th>
                                            <td class="text-center">{{ ($spsinfos->clienttransferspercentage=='1')?formatMoneyBr($spsinfos->clienttransfers).'%':'R$ '.formatMoneyBr($spsinfos->clienttransfers) }}</td>
                                            <td class="text-center">{{ ($spsinfos->clienttransferspercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Geração de boletos</th>
                                            <td class="text-center">{{ ($spsinfos->clientbilletspercentage=='1')?formatMoneyBr($spsinfos->clientbillets).'%':'R$ '.formatMoneyBr($spsinfos->clientbillets) }}</td>
                                            <td class="text-center">{{ ($spsinfos->clientbilletspercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Adiantamento de saldo</th>
                                            <td class="text-center">{{ ($spsinfos->clientbalanceusagepercentage=='1')?formatMoneyBr($spsinfos->clientbalanceusage).'%':'R$ '.formatMoneyBr($spsinfos->clientbalanceusage) }}</td>
                                            <td class="text-center">{{ ($spsinfos->clientbalanceusagepercentage=='1')?'percentual':'fixo' }}</td>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
       				
	                    <br>
	                    <hr>
	                    <br>
	                    <div class="text-center">
                            <a href="{{ url('spsinfo/'.$spsinfos->id) }}" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Alterar</a>
                        </div>

					</div>
				</div>
			</div>
		</div>
	</div>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
                <div class="card-body">
                    <div class=" text-center {{ ($extrato['Balance']<0)?'text-danger':'' }}">Saldo atual SPS: R$ {{ formatMoneyBr($extrato['Balance']) }}</div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('#billpayments, #transfers, #billets').maskMoney({
                prefix:'', 
                allowNegative: false, 
                thousands:'.', 
                decimal:',', 
                affixesStay: false,
                allowZero: true
            });
        });

        $('#bankbranch, #bankaccount, #bankaccountdigit').mask('#');
    </script>
@endsection
