@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Logs - Transações com FITBank</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataDe" name="dataDe" class="form-control datepickerDe" placeholder="Data inicial" value="{{ date2br($datafiltro['dataDe']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataAte" name="dataAte" class="form-control datepickerAte" placeholder="Data final" value="{{ date2br($datafiltro['dataAte']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}
                        
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <select name="client_id" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0">Administração</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ ($datafiltro['filtroCliente'] == $client->id )?'selected':'' }}>{{ $client->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Ação
                                </div>
                                <div class="col-md-8">
                                    <select name="sucesso" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0">Falha</option>
                                        <option value="1">Sucesso</option>                                      
                                    </select>
                                </div>
                            </div>
                        </div> {{-- row --}}

                    </div> {{-- form-body --}}

                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ date2br($datafiltro['dataDe']) }} a {{ date2br($datafiltro['dataAte']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Data
                                    </th>
                                    <th class="">
                                        Cliente
                                    </th>
                                    <th class="text-center">
                                        Resultado
                                    </th>
                                    <th class="">
                                        Mensagem (clique para mais detalhes)
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($erros as $erro)

                                    <?php
                                    $valid = unserialize($erro->validation);
                                    $validationString = '';
                                    if(!empty($valid)) {
                                        foreach($valid[0] as $k => $v) {
                                            if(is_array($v)) {
                                                foreach($v as $msg) {
                                                    $validationString .= $msg."<br>";
                                                } 
                                            }else {
                                                $validationString .= "<br>".$v."<br>";
                                            }
                                        }
                                    }

                                    ?>

                                    <tr  data-toggle="modal" data-target="#modal{{ $erro->id }}">
                                        <th class="text-nowrap" scope="row">{{ datetime2br($erro->transactiondate) }}</th>
                                        <td class="">{{ $erro->client }}</td>
                                        <td class="">{{ traduzSucessoLog($erro->success) }}</td>
                                        <td class="">{{ $erro->message }} {!! (!empty($validationString))?"<br><strong>Validação</strong>".$validationString:"" !!}</td>
                                    </tr>

                                        <!-- Modal -->
                                        <div class="modal fade" id="modal{{ $erro->id }}" tabindex="-1" role="dialog" aria-labelledby="modal{{ $erro->id }}Title" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-scrollable" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalCenterTitle">Detalhes da Transação</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <pre><b>Usuário : </b><code>{{ ($erro->name) }}</code></pre>
                                                        <pre><b>Data : </b><code>{{ ($erro->receiveddate) }}</code></pre>
                                                        <pre><b>Número do Documento : </b><code>{{ ($erro->documentnumber) }}</code></pre>
                                                        <pre><b>Dados enviados : </b><br><br><code>{{ ($erro->datasent) }}</code><br><br></pre>
                                                        <pre><b>Dados Recebidos</b><br><br><code>{{ ($erro->datareceived) }}
                                                        </code></pre>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-primary" data-dismiss="modal">Fechar</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('dataDe').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataAte').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('dataDe').value == '' || document.getElementById('dataDe').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection

