@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
				<div class="card-body">
					<div class=" text-center ">Limite da Operação (*): R$ {{ formatMoneyBr($limiteoperacao) }}</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title">Transferência entre Contas SSG</h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">
        				<br>
			        	<form action="{{ url('/transferenciainterna') }}" method="POST" onsubmit="return validaForm()">
                            @csrf
			                <div class="form-body">
			                    <div class="row">
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Valor</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="amount" id="amount" class="form-control" name="amount" placeholder="Valor">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Identificador</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="identificador" name="identificador" placeholder="Identificador">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Conta destino</span>
			                                </div>
			                                <div class="col-md-8">
			                                	@if(!$clients)
			                                		<p class="text-danger">Houve um problema ao carregar a lista de bancos. Por favor tente mais tarde.</p>
			                                	@else
				                                    <select id="taxnumber_destino_id" class="form-control" name="taxnumber_destino_id">
				                                    	<option value="0"> - Selecione - </option>
				                                    	@foreach($clients as $client)
				                                    		@if($cnpj_emuso != $client->taxnumber)
					                                    		<option value="{{ $client->taxnumber }}">{{ $client->name }}&nbsp;-&nbsp;{{ formataCNPJ($client->taxnumber)}}&nbsp;&nbsp;[R$ {{ formatMoneyBr($client->availablelimit) }}]</option>
					                                    	@endif
				                                    		@foreach($client->multiconta as $multi)
				                                    			@if($cnpj_emuso != $multi->taxnumber)
					                                    			<option value="{{ $multi->taxnumber }}"> - {{ $multi->nickname }}&nbsp;-&nbsp;{{ formataCNPJ($multi->taxnumber)}}&nbsp;&nbsp;[R$ {{ formatMoneyBr($multi->availablelimit) }}]</option>
					                                    		@endif
					                                    	@endforeach
				                                    	@endforeach
				                                    </select>
				                                @endif
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    &nbsp;
			                                </div>
			                                <div class="custom-control custom-checkbox col-md-8">
                                                <input type="checkbox" class="custom-control-input" checked="" name="limiteespecial" id="limiteespecial" value="1">
                                                <label class="custom-control-label" for="limiteespecial">Permitir utilização do saldo a compensar (**)</label>
                                            </div>
			                            </div>
			                        </div>
			                        <div class="col-md-8 offset-md-4">
			                        	<button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
			                            <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light" {{ (!$clients)?'disabled':'' }}>Realizar operação</button>
			                        </div>
			                        <div class="col-12">
			                            <p class="font-small-3">
			                            (*) Limite disponível para operação considerando o uso do saldo a compensar e a cobrança de eventuais taxas.			                            (**) Caso seu saldo atual seja menor que o valor determinado para transferência e você possua saldo a compensar, é possível completar o valor. Sujeito a cobrança de taxas.</p>
			                        </div>
			                    </div>
			                </div>
			            </form>

					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
				<div class="card-body">
					<div class=" text-center {{ ($extrato['Balance']<0)?'text-danger':'' }}">Saldo Atual: R$ {{ formatMoneyBr($extrato['Balance']) }}</div>
					<div class=" text-center ">Saldo a Compensar: R$ {{ formatMoneyBr($saldocompensar) }}</div>
				</div>
			</div>
		</div>
	</div>
	
</div>

@endsection

@section('inlinejs')
	<script type="text/javascript">
		$(function() {
		    $('#amount').maskMoney({
		    	prefix:'R$ ', 
		    	allowNegative: false, 
		    	thousands:'.', 
		    	decimal:',', 
		    	affixesStay: false
		    });
		})

		var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datatransf').pickadate(pickerOpt);
        
        function validaForm() {

            if( $("#amount").val() == '' || 
            	$("#amount").val() == '0' || 
	            $("#identificador").val() == '' || 
	            $("#taxnumber_destino_id").val() == '0') {
            	alert('Os campos são obrigatórios');
            	return false;
            }

            return true;
        }

	    $('#agencia').mask('#');
	    $('#conta').mask('#');
	    $('#digito').mask('#');
	</script>
@endsection
