@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
				<div class="card-body">
					<div class=" text-center ">Limite da Operação (*): R$ {{ formatMoneyBr($limiteoperacao) }}</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
        	
        	<div class="card">
        		<div class="card-header">
                    <h4 class="card-title">Transferência bancária</h4>
                </div>
        		<div class="card-content">
        			<div class="card-body">
        				<br>
			        	<form action="{{ url('/realizatransferenciabancaria') }}" method="POST" onsubmit="return validaForm()">
                            @csrf
			                <div class="form-body">
			                    <div class="row">
			                    	<div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Nome</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="nome" name="nome" placeholder="Nome destinatário">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Documento</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="documento" name="documento" placeholder="CPF/CNPJ">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Valor</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="amount" id="amount" class="form-control" name="valor" placeholder="Valor">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Identificador</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="identificador" name="identificador" placeholder="Identificador">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Data do pagamento</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control datatransf" id="datatransf" name="datatransf" placeholder="Data">
			                                </div>
			                            </div>
			                        </div>
									<div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Tipo conta</span>
			                                </div>
			                                <div class="col-md-8">
			                                	<select class="form-control" name="tipoconta">
													<option value="0" selected>Conta corrente</option>			                                		
													<option value="1">Poupança</option>			                                		
			                                	</select>
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Banco destinatário</span>
			                                </div>
			                                <div class="col-md-8">
			                                	@if(!$bancos)
			                                		<p class="text-danger">Houve um problema ao carregar a lista de bancos. Por favor tente mais tarde.</p>
			                                	@else
				                                    <select id="banco" class="form-control" name="banco">
				                                    	<option value="0"> - Selecione - </option>
				                                    	@foreach(json_decode($bancos) as $banco)
				                                    		<option value="{{ $banco->Code }}">{{ $banco->Code.' - '.$banco->Name }}</option>
				                                    	@endforeach
				                                    </select>
				                                @endif
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Agência (sem dígito)</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="agencia" name="agencia" placeholder="Agência">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Conta</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="conta" name="conta" placeholder="Conta sem dígito">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    <span>Dígito da conta</span>
			                                </div>
			                                <div class="col-md-8">
			                                    <input type="text" class="form-control" id="digito" name="digito" placeholder="Dígito da conta">
			                                </div>
			                            </div>
			                        </div>
			                        <div class="col-12">
			                            <div class="form-group row">
			                                <div class="col-md-4">
			                                    &nbsp;
			                                </div>
			                                <div class="custom-control custom-checkbox col-md-8">
                                                <input type="checkbox" class="custom-control-input" checked="" name="limiteespecial" id="limiteespecial" value="1">
                                                <label class="custom-control-label" for="limiteespecial">Permitir utilização do saldo a compensar (**)</label>
                                            </div>
			                            </div>
			                        </div>
			                        <div class="col-md-8 offset-md-4">
			                        	<button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
										<button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light" id="submitButtonTransferencia" {{ (!$bancos)?'disabled':'' }}>Realizar operação</button>
			                        </div>
			                        <div class="col-12">
			                            <p class="font-small-3">
			                            (*) Limite disponível para operação considerando o uso do saldo a compensar e a cobrança de eventuais taxas.			                            (**) Caso seu saldo atual seja menor que o valor determinado para transferência e você possua saldo a compensar, é possível completar o valor. Sujeito a cobrança de taxas.</p>
			                        </div>
			                    </div>
			                </div>
			            </form>

					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
				<div class="card-body">
					<div class=" text-center {{ ($extrato['Balance']<0)?'text-danger':'' }}">Saldo Atual: R$ {{ formatMoneyBr($extrato['Balance']) }}</div>
					<div class=" text-center ">Saldo a Compensar: R$ {{ formatMoneyBr($saldocompensar) }}</div>
				</div>
			</div>
		</div>
	</div>
	
</div>

@endsection

@section('inlinejs')
	<script type="text/javascript">
		$(function() {
		    $('#amount').maskMoney({
		    	prefix:'R$ ', 
		    	allowNegative: false, 
		    	thousands:'.', 
		    	decimal:',', 
		    	affixesStay: false
		    });
		})

		var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datatransf').pickadate(pickerOpt);
        
        function validaForm() {
            var dataDe = document.getElementById('datatransf').value;
            var filtrode = new Date(dataDe);
            var filtroate = new Date('<?=date('d/m/Y')?>');
            
            if(document.getElementById('datatransf').value == '') {
                alert('Preencha a data.');
                return false;
            }

            if ( filtrode < filtroate ) { 
                alert('A data não pode ser menor que a data atual.');
                return false;
            }

            if( $("#nome").val() == '' ||
	            	$("#amount").val() == '' || 
	            	$("#identificador").val() == '' || 
	            	$("#banco").val() == '0' || 
	            	$("#agencia").val() == '' || 
	            	$("#documento").val() == '' || 
	            	$("#conta").val() == '' || 
	            	$("#digito").val() == '') {
            	alert('Os campos são obrigatórios');
            	return false;
            }

			// Data: 13/07/2022
			// Autor: Fábio
			// Desabilita o submit button quando o usuário clica em Realizar Operação
			// Soluciona o problema do usuário clicar diversas vezes no mesmo botão e realizar multiplas operações 
			$("#submitButtonTransferencia")
				.attr('disabled', true)
                .html('<i class="fa fa-spinner fa-spin fa-fw"></i>Processando...')
                .removeClass('btn-primary')
                .addClass('btn-danger');

            return true;
        }

        var options = {
	        onKeyPress: function (cpf, ev, el, op) {
	            var masks = ['000.000.000-000', '00.000.000/0000-00'];
	            $('#documento').mask((cpf.length > 14) ? masks[1] : masks[0], op);
	        }
	    }

	    $('#documento').length > 11 ? $('#documento').mask('00.000.000/0000-00', options) : $('#documento').mask('000.000.000-00#', options);

	    $('#agencia').mask('#');
	    $('#conta').mask('#');
	    $('#digito').mask('#');
	</script>
@endsection
