@extends('layouts.authenticated')

@section('extracss')
    <style>
        .client-search-result-item:checked + label {
            font-weight: bold !important;
        }
    </style>
@endsection

@section('extrajs')
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
    <div class="container">
        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12 text-right">
                <h2>Transferência Simples - Cliente</h2>
            </div>
        </div>

        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">

                <div class="card">

                    <div class="card-header">
                        <h4 class="card-title">Transferência para conta Fitbank Cliente</h4>
                    </div>

                    <div class="card-content">

                        <div class="card-body p-2">

                            <form action="{{ url('/transferenciacliente') }}" method="POST">
                                @csrf
                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <span>Buscar Cliente</span>
                                        </div>

                                        <div class="col-md-6">
                                            <input type="text" id="name" class="form-control" name="name"
                                               placeholder="Nome" required />
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-primary mr-1 mb-1 waves-effect
                                            waves-light" id="client-search-button">
                                                <i class="feather icon-search"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div id="client-search-results-wrapper" class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                        </div>

                                        <div id="client-search-results" class="col-md-8">
                                        </div>
                                    </div>
                                </div>


                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <span>Valor</span>
                                        </div>
                                        <div class="col-md-8">
                                            <input type="valor" id="valor" class="form-control" name="valor" placeholder="Valor" value="" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <span>Identificador</span>
                                        </div>
                                        <div class="col-md-8">
                                            <input type="identifier" id="identifier" class="form-control" name="identifier" placeholder="Identificador" value="">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="col-md-8 offset-md-4">
                                        <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Enviar</button>
                                        <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
                                    </div>
                                </div>
                            </form>
                            @if($errors->any())
                                <div>
                                    @foreach($errors->all() as $error)
                                        <span class="text-danger block">
                                            {{ $error }}
                                        </span>
                                    @endforeach
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">
                <div class="card">
                    <div class="card-body">
                        <div class=" text-center {{ ($extrato['Balance']<0)?'text-danger':'' }}">Saldo SSG: R$ {{
                        formatMoneyBr($extrato['Balance']) }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {

            $('#client-search-button').click((e) => {
                e.preventDefault();

                $('#client-search-results').html('Buscando...');

                let search = $('#name').val();

                $.ajax({
                    url: '{{ route('clientes.detalhes') }}',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        _token: '{{ csrf_token() }}',
                        name: search
                    },
                    success: (response) => {
                        $('#client-search-results').html('');

                        if (response.success) {
                            if (response.data.length === 0) {
                                console.log(response.data.length)
                                $('#client-search-results').html('Nenhum cliente encontrado');
                                $('#name').val('');
                                return;
                            }

                            response.data.forEach((item) => {
                                $('#client-search-results').append(`
                                    <div class="form-check">
                                        <input type="radio"
                                            id="taxnumber_${item.id}"
                                            name="taxnumber"
                                            class="form-check-input client-search-result-item"
                                            value="${item.taxnumber}" />
                                        <label class="form-check-label" for="taxnumber_${item.id}">
                                            ${item.name} [R$ ${item.availablelimit}]
                                        </label>
                                    </div>
                                `);

                                $('#client-search-results-wrapper').removeClass('d-none');
                            });
                        } else {
                            $('#client-search-results-wrapper').addClass('d-none');
                        }
                    }
                });
            });

            $('#valor').maskMoney({
                prefix:'R$ ',
                allowNegative: false,
                thousands:'.',
                decimal:',',
                affixesStay: false
            });
        });

        const formulario = document.querySelector('form');
        const botaoSubmit = formulario.querySelector('button[type="submit"]');
        formulario.addEventListener('submit', (evento) => {
            botaoSubmit.disabled = true;
        });
    </script>
@endsection

