@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>

    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                    <br>

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($datafiltro['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($datafiltro['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Situação
                                </div>
                                <div class="col-md-8">
                                    <select name="filtrostatus" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0" {{ ($datafiltro['filtrostatus'] == '0')?'selected':'' }}>Aguardando</option>
                                        <option value="Paid" {{ ($datafiltro['filtrostatus'] == 'Paid')?'selected':'' }}>Pago</option>
                                        <option value="Incluido" {{ ($datafiltro['filtrostatus'] == 'Incluido')?'selected':'' }}>Incluido</option>
                                        <option value="Autorizado" {{ ($datafiltro['filtrostatus'] == 'Autorizado')?'selected':'' }}>Autorizado</option>
                                        <option value="Cancel" {{ ($datafiltro['filtrostatus'] == 'Cancel')?'selected':'' }}>Cancelado</option>
                                        <option value="Registered" {{ ($datafiltro['filtrostatus'] == 'Registered')?'selected':'' }}>Registrado</option>
                                        <option value="Rejected" {{ ($datafiltro['filtrostatus'] == 'Rejected')?'selected':'' }}>Rejeitado</option>
                                        <option value="ErrorBalance" {{ ($datafiltro['filtrostatus'] == 'ErrorBalance')?'selected':'' }}>Erro de saldo</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Conta
                                </div>
                                <div class="col-md-8">
                                    <input type="hidden" name="taxnumber" value="{{ Session::get('cnpj') }}">
                                    <strong>{{ formataCNPJ( Session::get('cnpj') ) }}</strong>
                                </div>
                            </div>

                        </div> {{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ ($datafiltro['datade']) }} a {{ ($datafiltro['dataate']) }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Data
                                    </th>
                                    {{--
                                    <th class="text-center">
                                        Situação
                                    </th>
                                    --}}
                                    <th class="text-center">
                                        Detalhes
                                    </th>
                                    <th class="text-center">
                                        Valor
                                    </th>
                                    <th class="text-center">
                                        Identificador
                                    </th>
                                    {{-- <th class="text-center">
                                        Doc. Num.
                                    </th> --}}
                                    <th class="text-center">
                                        Comp.
                                    </th>
                                    <th class="text-center">
                                        Ações
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tlogs as $tlog)
                                    <?php $cliente = getClientById($tlog->client_id) ?>
                                    <?php $user = getUserById($tlog->user_id) ?>
                                    <tr>
                                        <th class="text-nowrap" scope="row">{{ datetime2br($tlog->actiondate) }}<br>{!! traduzStatus($tlog->status) !!}</th>
                                        {{-- <td class="text-nowrap">{{ $tlog->status }}</td> --}}
                                        <td class="text-nowrap">{!!
                                                                "Nome:&nbsp;<strong>".$tlog->nome."</strong><br>".
                                                                "Documento:&nbsp;<strong>".formataCNPJ($tlog->documento)."</strong><br>".
                                                                "Banco:&nbsp;<strong>".$tlog->banco."</strong><br>".
                                                                "Agência:&nbsp;<strong>".$tlog->agencia."</strong><br>".
                                                                "Conta:&nbsp;<strong>".$tlog->conta."-".$tlog->digito."</strong><br>".
                                                                "Tipo conta:&nbsp;<strong>".(($tlog->tipoconta==0)?'Corrente':'Poupança')."</strong>"

                                                                !!}</td>
                                        <td class="text-nowrap">R$ {{ formatMoneyBr($tlog->valor) }}</td>
                                        <td class="text-nowrap">{{ $tlog->identificador }}</td>
                                        {{-- <td class="text-nowrap">{{ $tlog->documentnumber }}</td> --}}
                                        <td class="text-center">
                                            @if(!empty($tlog->url))
                                                <a href="{{ $tlog->url }}" target="_blank" class="text-danger"><i class="fa fa-file-pdf-o"></i></a>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @can('transferencia.bancaria.gerenciar.autorizar')
                                                @if($tlog->status == "Incluido")
                                                    <form action="{{ url('/transferencias/bancaria/autorizar') }}" method="post">
                                                        @csrf
                                                        <input type="hidden" name="transfermanagerid" value="{{ $tlog->id }}">
                                                        <a class="icon"><button type="submit" class="fabutton"><i class="feather text-primary icon-play"></i></button></a>
                                                    </form>
                                                @endif
                                            @endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        $('.fabutton').css('background', 'none');
        $('.fabutton').css('border', 'none');



        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);

            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) {
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }

    </script>
@endsection

