@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif
    
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($datafiltro['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($datafiltro['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Situação
                                </div>
                                <div class="col-md-8">
                                    <select name="filtrostatus" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0" {{ ($datafiltro['filtrostatus'] == '0')?'selected':'' }}>Aguardando</option>
                                        <option value="Paid" {{ ($datafiltro['filtrostatus'] == 'Paid')?'selected':'' }}>Pago</option>
                                        <option value="Cancel" {{ ($datafiltro['filtrostatus'] == 'Cancel')?'selected':'' }}>Cancelado</option>
                                        <option value="Registered" {{ ($datafiltro['filtrostatus'] == 'Registered')?'selected':'' }}>Registrado</option>
                                        <option value="Rejected" {{ ($datafiltro['filtrostatus'] == 'Rejected')?'selected':'' }}>Rejeitado</option>
                                        <option value="ErrorBalance" {{ ($datafiltro['filtrostatus'] == 'ErrorBalance')?'selected':'' }}>Erro de saldo</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Conta
                                </div>
                                <div class="col-md-8">
                                    <input type="hidden" name="taxnumber" value="{{ Session::get('cnpj') }}">
                                    <strong>{{ formataCNPJ( Session::get('cnpj') ) }}</strong>
                                </div>
                            </div>

                        </div> {{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ ($datafiltro['datade']) }} a {{ ($datafiltro['dataate']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Data
                                    </th>
                                    <th class="text-center">
                                        Vencimento
                                    </th>
                                    <th class="text-center">
                                        Pagamento
                                    </th>
                                    <th class="text-center">
                                        Status
                                    </th>
                                    <th class="text-center">
                                        Identificador
                                    </th>
                                    <th class="text-center">
                                        ID
                                    </th>
                                    <th class="text-center">
                                        Valor
                                    </th>
                                    <th class="text-center">
                                        Desconto
                                    </th>
                                    <th class="text-center">
                                        Jur./Multa
                                    </th>
                                    <th class="text-center">
                                        Comp.
                                    </th>
                                    <th class="text-center">
                                        
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tlogs as $tlog)
                                    <?php $cliente = getClientById($tlog->client_id) ?>
                                    <?php $user = getUserById($tlog->user_id) ?>
                                    <tr onClick='showWarning( {{ $tlog->id }} )'>
                                        <th class="text-nowrap" scope="row">{{ datetime2br($tlog->emission) }}</th>
                                        <td class="text-nowrap">{{ detectDateFormatOutputDateBr($tlog->duedate) }}</td>
                                        <td class="text-nowrap">{{ detectDateFormatOutputDateBr($tlog->paymentdate) }}</td>
                                        <td class="text-center">{!! traduzStatus($tlog->status) !!}</td>
                                        <td>{{ $tlog->identifier }}</td>
                                        <td>{{ $tlog->documentnumber }}</td>
                                        <td>{{ formatMoneyBr($tlog->principalvalue) }}</td>
                                        <td>{{ formatMoneyBr($tlog->discountvalue) }}</td>
                                        <td>{{ ($tlog->cip==0)?formatMoneyBr($tlog->extravalue):formatMoneyBr($tlog->totaladdedvalue) }}</td>
                                        <td class="text-center">
                                            @if(!empty($tlog->url))
                                                <a href="{{ $tlog->receipturl }}" target="_blank" class="text-danger"><i class="fa fa-file-pdf-o"></i></a>
                                            @endif
                                        </td>
                                        <td><i class="fa fa-eye text-primary" id="viewicon{{ $tlog->id }}"></i></td>
                                    </tr>
                                    <tr id="showWarningDiv{{ $tlog->id }}" style="display: none; border-bottom: 2px solid #ccc">
                                        <td colspan="11">
                                            <?php $user = getUserById($tlog->user_id)?>
                                            <p>Usuário: {{ $user->name }}</p>
                                            @if(!empty( $tlog->barcode )) <p>Cod. barras: {{ $tlog->barcode }}</p> @endif
                                        </td>
                                    </tr>
                                    <tr style="display: none;"><td colspan="11"></td></tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }

        function showWarning(id) {
            $('#showWarningDiv'+id).toggle("slow");
            if($('#viewicon'+id).hasClass("fa-eye")) {
                $('#viewicon'+id).removeClass("fa-eye");
                $('#viewicon'+id).addClass("fa-eye-slash");
            } else {
                $('#viewicon'+id).removeClass("fa-eye-slash");
                $('#viewicon'+id).addClass("fa-eye");
            }
            
        }
    </script>
@endsection

