@extends('layouts.authenticated')

@section('content')
<div class="container">
	<div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
			<div class="card">
                <div class="card-header">
                    <h4 class="card-title">{{ $client->nickname }}</h4>
                </div>
	            <div class="card-body">
                    <div class="mt-1">
                        <h6 class="mb-0">Razão social</h6>
                        <p>{{ $client->name }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">CNPJ/CPF</h6>
                        <p>{{ formataCNPJ($client->taxnumber) }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">Email</h6>
                        <p>{{ $client->mail }}</p>
                    </div>
                    <div class="mt-1">
                        <h6 class="mb-0">Telefone</h6>
                        <p>{{ $client->phone }}</p>
                    </div>

                    <div class="mt-1">
                        <h6 class="mb-0">Permitir limite especial</h6>
                        <p>{{ ($client->availablelimit==1)?'Sim':'Não' }}</p>
                    </div>

                <br><br>

                <div class="row">
                    <div class="col-12">
                            <div class="divider divider-info">
                                <div class="divider-text">Taxas</div>
                            </div>

                            <br><br>

                            <div class="row">
                            <div class="col-12">
                                <div class="form-group row">
                                    <div class="col-md-4">
                                        <span>Taxas diferenciadas:</span>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>{{ ($client->customrates==1)?'Sim':'Não' }}</strong>
                                    </div>
                                </div>
                            </div>
                            </div>

                            <div class="row">
                            <div class="col-12">
                                <div class="form-group row">
                                    <div class="col-md-4">
                                        <span>Dia do vencimento tarifa:</span>
                                    </div>
                                    <div class="col-md-4">
                                        <strong>{{ $client->monthlyfeedueday }}</strong>
                                    </div>
                                </div>
                            </div>
                            </div>

                            <table class="table table-striped table-bordered">
                                <thead>
                                    <th>Transação</th>
                                    <th class="text-center">Custo</th>
                                    <th class="text-center">Tipo</th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <th scope="row">Pagamentos</th>
                                        <td class="text-center">{{ ($client->paymentspercentage=='1')?formatMoneyBr($client->payments).'%':'R$ '.formatMoneyBr($client->payments) }}</td>
                                        <td class="text-center">{{ ($client->paymentspercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Transferências (DOC/TED)</th>
                                        <td class="text-center">{{ ($client->transferspercentage=='1')?formatMoneyBr($client->transfers).'%':'R$ '.formatMoneyBr($client->transfers) }}</td>
                                        <td class="text-center">{{ ($client->transferspercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Geração de boletos</th>
                                        <td class="text-center">{{ ($client->billetspercentage=='1')?formatMoneyBr($client->billets).'%':'R$ '.formatMoneyBr($client->billets) }}</td>
                                        <td class="text-center">{{ ($client->billetspercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Adiantamento de saldo</th>
                                        <td class="text-center">{{ ($client->balanceusagepercentage=='1')?formatMoneyBr($client->balanceusage).'%':'R$ '.formatMoneyBr($client->balanceusage) }}</td>
                                        <td class="text-center">{{ ($client->balanceusagepercentage=='1')?'percentual':'fixo' }}</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">Tarifa mensal</th>
                                        <td class="text-center">{{ formatMoneyBr($client->monthlyfee) }}</td>
                                        <td class="text-center">Fixo</td>
                                    </tr>
                                </tbody>
                            </table>
                    </div>
                </div>

                    <br><br>

                    <div class="divider divider-info">
                        <div class="divider-text">Usuário(s) com acesso</div>
                    </div>
                    <br><br>
                    <?php $usuarios = usuariosCliente($client->id); ?>
                    @foreach($usuarios as $usr)
                        <p class="{{ ($usr->active==0)?'text-muted':'' }}">{{ $usr->name.' ('.$usr->email.')' }} &nbsp;&nbsp;&nbsp; @if($usr->active==0) <span class="badge badge-light">Inativo</span> @endif</p>
                    @endforeach

	            </div>
	        </div>
           
		</div>
	</div>
</div>

@endsection

