@extends('layouts.authenticated')
 
@section('extrajs')
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection
 
@section('content')
<div class="container">
    <div class="row justify-content-md-center text-right separator-b-10">
        <div class="col-md-8 col-12 text-right d-flex justify-content-end">
            <button type="button" class="btn btn-md btn-icon btn-primary waves-effect waves-light mr-1" data-toggle="modal" data-target="#clientFilterModal">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-funnel" viewBox="0 0 16 16">
                    <path d="M1.5 1.5A.5.5 0 0 1 2 1h12a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.128.334L10 8.692V13.5a.5.5 0 0 1-.342.474l-3 1A.5.5 0 0 1 6 14.5V8.692L1.628 3.834A.5.5 0 0 1 1.5 3.5zm1 .5v1.308l4.372 4.858A.5.5 0 0 1 7 8.5v5.306l2-.666V8.5a.5.5 0 0 1 .128-.334L13.5 3.308V2z"/>
                </svg>
                Filtrar clientes
            </button>
            <button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light" data-toggle="modal" data-target="#inlineForm"><i class="feather icon-plus"></i> Adicionar cliente</button>  
        </div>
        <x-modal-filtro-client />
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12 text-right">
            @if(empty($clients[0]))
                <div class="card bg-danger text-white border-danger">
                    <div class="card-header">Conjunto vazio</div>
                    <div class="card-body">
                        <p class="card-text">Nenhum cliente foi encontrado</p>
                    </div>
                </div>
            @else
                @foreach($clients as $client)
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title {{ ($client->active==0)?'text-muted':'' }}">
                                {{ $client->nickname }} &nbsp;&nbsp;&nbsp; @if($client->active==0) <span class="badge badge-light">Inativo</span> @endif
                            </h4>
                            @if(empty($client->businessunitid))
                                <a href="{{ url('/enviaclientefitbank/'.$client->id) }}"><button class="btn btn-sm btn-info">Enviar para Fitbank</button></a>
                            @endif
                            <div class="mt-1 text-right">
                                <a href="{{ url('clientes/'.$client->id) }}">
                                    <i class="feather icon-eye text-info"></i>
                                </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="{{ url('clientes/'.$client->id.'/editar') }}">
                                    <i class="feather icon-edit text-primary"></i>
                                </a>
                                &nbsp;&nbsp;&nbsp;
                                <a href="#" data-toggle="modal" data-target="#status-{{$client->id}}">
                                    <i class="feather {{ ($client->active==0)?'icon-check-circle text-success':'icon-x-circle text-danger' }}"></i>
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                           
                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <h6 class="mb-0">Razão social</h6>
                                    <p>{{ $client->name }}</p>
                                </div>
                                <div class="col-md-6 col-12">
                                    <h6 class="mb-0">CNPJ/CPF</h6>
                                    <p>{{ formataCNPJ($client->taxnumber) }}</p>
                                </div>
                            </div>
 
                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <h6 class="mb-0">Email</h6>
                                    <p>{{ $client->mail }}</p>
                                </div>
                                <div class="col-md-6 col-12">
                                    <h6 class="mb-0">Telefone</h6>
                                    <p>{{ formataTelefone($client->phone) }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                        {{-- MODAL EDITA USUARIO --}}
                        <div class="modal fade text-left" id="cliente_usuario_{{$client->id}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel33">{{ $client->nickname }} - Novo usuário</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span>
                                        </button>
                                    </div>
                                    <form action="{{ url('/usuarios') }}" method="POST">
                                        @csrf
                                        <div class="modal-body">                                           
                                            <input type="hidden" name="client_id" value="{{$client->id}}">
                                            <label>Nome: </label>
                                            <div class="form-group">
                                                <input type="text" name="name" placeholder="Nome" class="form-control">
                                            </div>
 
                                            <label>Email: </label>
                                            <div class="form-group">
                                                <input type="text" name="email" placeholder="Email Address" class="form-control">
                                            </div>
                                            <div class="font-small-3">
                                                <i class="feather icon-alert-triangle text-warning"></i>&nbsp;<span class="text-danger">Uma senha será gerada e enviada para o email.</span>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        {{-- MODAL EDITA USUARIO --}}
 
                        {{-- MODAL STATUS CLIENTE --}}
                        <div class="modal fade text-left" id="status-{{ $client->id }}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel33">{{ $client->name }} - {{ ($client->active==1)?'Desativar':'Ativar' }}</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">×</span>
                                        </button>
                                    </div>
                                    <form action="{{ url('/clientes/'.$client->id.'/mudastatus') }}" method="POST">
                                        @csrf
                                        <div class="modal-body">
                                            <input type="hidden" name="id" value="{{ $client->id }}">
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">{{ ($client->active==1)?'Desativar':'Ativar' }}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        {{-- MODAL STATUS CLIENTE --}}
 
 
 
                @endforeach
            @endif
        </div>
    </div>
</div>
 
 
 
{{-- MODAL CRIA CLIENTE --}}
<div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="myModalLabel33">Novo cliente</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form action="{{ url('/clientes') }}" method="POST" onsubmit="return validaCpfCnpj()">
                @csrf
                <div class="modal-body">
                    <label>Razão social</label>
                    <div class="form-group">
                        <input type="text" name="name" placeholder="Nome" class="form-control">
                    </div>
 
                    <label>Nome fantasia</label>
                    <div class="form-group">
                        <input type="text" name="nickname" placeholder="" class="form-control">
                        <span class="text-muted">A acentuação será removida automaticamente ao salvar</span>
                    </div>
 
                    <label>CNPJ/CPF</label>
                    <div class="form-group">
                        <input type="text" name="taxnumber" id="cpfcnpj" placeholder="" class="form-control">
                    </div>
 
                    <label>Email</label>
                    <div class="form-group">
                        <input type="text" name="mail" placeholder="" class="form-control">
                    </div>
 
                    <label>Telefone</label>
                    <div class="form-group">
                        <input type="text" name="phone" placeholder="" class="form-control">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- MODAL CRIA CLIENTE --}}
 
@endsection
 
@section('inlinejs')
<script type="text/javascript">
    var options = {
        onKeyPress: function (cpf, ev, el, op) {
            var masks = ['000.000.000-000', '00.000.000/0000-00'];
            $('#cpfcnpj').mask((cpf.length > 14) ? masks[1] : masks[0], op);
        }
    }
 
    $('#cpfcnpj').length > 11 ? $('#cpfcnpj').mask('00.000.000/0000-00', options) : $('#cpfcnpj').mask('000.000.000-00#', options);
 
 
    function validaCpfCnpj() {
 
        var val = $('#cpfcnpj').val();
 
        if (val.length < 15) {
            var cpf = val.trim();
         
            cpf = cpf.replace(/\./g, '');
            cpf = cpf.replace('-', '');
            cpf = cpf.split('');
           
            var v1 = 0;
            var v2 = 0;
            var aux = false;
           
            for (var i = 1; cpf.length > i; i++) {
                if (cpf[i - 1] != cpf[i]) {
                    aux = true;  
                }
            }
           
            if (aux == false) {
                alert('Verifique o CPF/CNPJ');
                return false;
            }
           
            for (var i = 0, p = 10; (cpf.length - 2) > i; i++, p--) {
                v1 += cpf[i] * p;
            }
           
            v1 = ((v1 * 10) % 11);
           
            if (v1 == 10) {
                v1 = 0;
            }
           
            if (v1 != cpf[9]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            }
           
            for (var i = 0, p = 11; (cpf.length - 1) > i; i++, p--) {
                v2 += cpf[i] * p;
            }
           
            v2 = ((v2 * 10) % 11);
           
            if (v2 == 10) {
                v2 = 0;
            }
           
            if (v2 != cpf[10]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            } else {  
                return true;
            }
        } else if (val.length > 15) {
            var cnpj = val.trim();
           
            cnpj = cnpj.replace(/\./g, '');
            cnpj = cnpj.replace('-', '');
            cnpj = cnpj.replace('/', '');
            cnpj = cnpj.split('');
           
            var v1 = 0;
            var v2 = 0;
            var aux = false;
           
            for (var i = 1; cnpj.length > i; i++) {
                if (cnpj[i - 1] != cnpj[i]) {  
                    aux = true;  
                }
            }
           
            if (aux == false) {  
                alert('Verifique o CPF/CNPJ');
                return false;
            }
           
            for (var i = 0, p1 = 5, p2 = 13; (cnpj.length - 2) > i; i++, p1--, p2--) {
                if (p1 >= 2) {  
                    v1 += cnpj[i] * p1;  
                } else {  
                    v1 += cnpj[i] * p2;  
                }
            }
           
            v1 = (v1 % 11);
           
            if (v1 < 2) {
                v1 = 0;
            } else {
                v1 = (11 - v1);
            }
           
            if (v1 != cnpj[12]) {  
                alert('Verifique o CPF/CNPJ');
                return false;
            }
           
            for (var i = 0, p1 = 6, p2 = 14; (cnpj.length - 1) > i; i++, p1--, p2--) {
                if (p1 >= 2) {  
                    v2 += cnpj[i] * p1;  
                } else {  
                    v2 += cnpj[i] * p2;
                }
            }
           
            v2 = (v2 % 11);
           
            if (v2 < 2) {  
                v2 = 0;
            } else {
                v2 = (11 - v2);
            }
           
            if (v2 != cnpj[13]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            } else {  
                return true;
            }
        } else {
            alert('Verifique o CPF/CNPJ');
            return false;
        }
    }
</script>
@endsection