@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
    <script src="{{ asset('js/jquery.mask.min.js') }}"></script>
@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif
    
    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Pagamento GPS</h4>
                </div>
                <div class="card-content">
                    <div class="card-body">
                        <br>
                        <form action="{{ url('/gps/enviar') }}" method="POST" onsubmit="return validaForm()">
                            @csrf
                           
                            <label>CPF/CNPJ do pagador: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="taxnumber"  name="taxnumber" placeholder="" class="form-control" value="{{ formataCNPJ(Session::get('cnpj')) }}">
                            </div>

                            <label>CPF/CNPJ do contribuinte: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="contributortaxnumber"  name="contributortaxnumber" placeholder="" class="form-control" value="">
                            </div>

                            <label>Valor principal: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="principalvalue"  name="principalvalue" placeholder="" class="form-control" value="">
                            </div>

                            <label>Somatória juros e multa: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="fineinterestvalue"  name="fineinterestvalue" placeholder="" class="form-control" value="0">
                            </div>

                            <label>Outros valores: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="othervalues"  name="othervalues" placeholder="" class="form-control" value="0">
                            </div>

                            <label>Data de vencimento: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="duedate"  name="duedate" placeholder="" class="form-control" value="">
                            </div>

                            <label>Data de pagamento: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="paymentdate"  name="paymentdate" placeholder="" class="form-control" value="">
                            </div>

                            <label>Descrição: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="description"  name="description" placeholder="" class="form-control" value="">
                            </div>

                            <label>Identificador: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="identifier"  name="identifier" placeholder="" class="form-control" value="">
                            </div>

                            <label>Código de pagamento: </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="paymentcode"  name="paymentcode" placeholder="" class="form-control" value="">
                            </div>

                            <label>Período de referência (MMAAAA): </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="referencenumber"  name="referencenumber" placeholder="" class="form-control" value="">
                            </div>

                            <label>Mês e ano da competência (MMAAAA): </label>
                            <div class="form-group col-md-12">
                                <input type="text" id="jurisdictiondate"  name="jurisdictiondate" placeholder="" class="form-control" value="">
                            </div>

                            <div class="custom-control custom-checkbox col-md-8">
                                <input type="checkbox" class="custom-control-input" checked="" name="limiteespecial" id="limiteespecial" value="1">
                                <label class="custom-control-label" for="limiteespecial">Permitir utilização do saldo a compensar (*)</label>
                            </div><br>
                            
                            <div class="col-md-8 offset-md-4">
                                <button type="reset" class="btn btn-outline-warning mr-1 mb-1 waves-effect waves-light">Limpar</button>
                                <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Pagar</button>
                            </div>


                            <div class="col-12">
                                <p class="font-small-3 text-muted">(*) Caso seu limite disponível seja menor que o valor determinado para transferência e você possua saldo a compensar, é possível completar o valor. Sujeito a cobrança de taxas.</p>
                            </div> 

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('#principalvalue, #fineinterestvalue, #othervalues').maskMoney({
                prefix:'', 
                allowNegative: false, 
                thousands:'.', 
                decimal:',', 
                affixesStay: false,
                allowZero: true
            });
        });

        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };


        $('#paymentdate,#duedate').pickadate(pickerOpt);
        
        function validaForm() {
           
            if( 
                $('#taxnumber').val() == '' ||
                $('#contributortaxnumber').val() == '' ||
                $('#principalvalue').val() == '' ||
                $('#paymentdate').val() == '' ||
                $('#identifier').val() == '' ||
                $('#paymentcode').val() == '' ||
                $('#referencenumber').val() == '' ||
                $('#jurisdictiondate').val() == ''
                
                ) {
                alert('Verifique os campos obrigatórios');
                return false;
            }

            var datapagto = $('#paymentdate').val();
            var dtsplit = datapagto.split('/');
            var dtpagto = new Date(dtsplit[2],dtsplit[1]-1,dtsplit[0]);
            var dataref = new Date();
                dataref.setHours(0,0,0,0); // zera as horas
            
            if(document.getElementById('paymentdate').value == '') {
                alert('Preencha a data de pagamento.');
                return false;
            }

            if ( dtpagto.getTime() < dataref.getTime() ) { 
                alert('A data de pagamento não pode ser menor que a data atual.');
                return false;
            }
            
            return true;
        }

        var options = {
            onKeyPress: function (cpf, ev, el, op) {
                var masks = ['000.000.000-000', '00.000.000/0000-00'];
                $('#contributortaxnumber').mask((cpf.length > 14) ? masks[1] : masks[0], op);
            }
        }

        $('#contributortaxnumber').length > 11 ? $('#contributortaxnumber').mask('00.000.000/0000-00', options) : $('#contributortaxnumber').mask('000.000.000-00#', options);

        $('#referencenumber').mask('#');
        $('#jurisdictiondate').mask('#');
    </script>
@endsection
