@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">

    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif
    
    <div class="row justify-content-md-center">
        <div class="col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($datafiltro['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($datafiltro['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Situação
                                </div>
                                <div class="col-md-8">
                                    <select name="filtrostatus" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0" {{ ($datafiltro['filtrostatus'] == '0')?'selected':'' }}>Aguardando</option>
                                        <option value="Paid" {{ ($datafiltro['filtrostatus'] == 'Paid')?'selected':'' }}>Pago</option>
                                        <option value="Cancel" {{ ($datafiltro['filtrostatus'] == 'Cancel')?'selected':'' }}>Cancelado</option>
                                        <option value="Registered" {{ ($datafiltro['filtrostatus'] == 'Registered')?'selected':'' }}>Registrado</option>
                                        <option value="Rejected" {{ ($datafiltro['filtrostatus'] == 'Rejected')?'selected':'' }}>Rejeitado</option>
                                        <option value="ErrorBalance" {{ ($datafiltro['filtrostatus'] == 'ErrorBalance')?'selected':'' }}>Erro de saldo</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Conta
                                </div>
                                <div class="col-md-8">
                                    <input type="hidden" name="taxnumber" value="{{ Session::get('cnpj') }}">
                                    <strong>{{ formataCNPJ( Session::get('cnpj') ) }}</strong>
                                </div>
                            </div>

                        </div> {{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>
    


    <div class="row justify-content-md-center">
        <div class="col-12">    
            <div class="card">
                <div class="card-body text-center">
                    <div class="row">
                        <div class="col-md-12">Período: {{ dataUs2Br($datafiltro['datade']) }} a {{ dataUs2Br($datafiltro['dataate']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div>    

    @if($gpss->isEmpty())
        <div class="row justify-content-md-center">
            <div class="col-12">    
                <div class="card">
                    <div class="card-body text-center">
                        <div class="row">
                            <div class="col-md-12">Nenhum resultado no período selecionado</div>
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>    
    @endif

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Data
                                    </th>
                                    <th class="text-center">
                                        Detalhes
                                    </th>
                                    <th class="text-center">
                                        Identificador
                                    </th>
                                    <th class="text-center">
                                        Status
                                    </th>
                                    <th class="text-center">
                                        Vencimento
                                    </th>
                                    <th class="text-center">
                                        Valor
                                    </th>
                                    <th class="text-center">
                                        Comp.
                                    </th>
                                </tr>
                            </thead>
                            <tbody>

                            @foreach($gpss as $gps)
                                <?php $cliente = getClientById($gps->client_id) ?>
                                <?php $user = getUserById($gps->user_id) ?>
                                <tr>
                                    <th class="text-nowrap" scope="row">{{ datetime2br($gps->emission) }}</th>
                                    <td class="text-nowrap"></td>
                                    
                                    <td class="text-nowrap">{{ $gps->identifier }}</td>
                                    <td class="text-nowrap text-center">{!! traduzStatus($gps->status) !!}</td>
                                    <td class="text-nowrap text-center">{{ detectDateFormatOutputDateBr($gps->duedate) }}</td>
                                    <td class="text-nowrap text-right">R$ {{ formatMoneyBr($gps->totalvalue) }}</td>
                                    <td class="text-center">
                                        @if(!empty($gps->receipturl))
                                            <a href="{{ $gps->receipturl }}" target="_blank" class="text-danger"><i class="fa fa-file-pdf-o"></i></a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection
