@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">


    <?php $multicnpj = getMultiCnpj();?>
    
    @if(!empty($multicnpj))
        <?php $multiCofres = multiCofres(Session::get('cnpj'), Request::path());?>
        {!! $multiCofres !!}
    @endif

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
            <div class="card-body">
                <div class="row">Selecione o período</div>
                <form class="form form-horizontal" onsubmit="validaForm()" method="POST">
                    @csrf
                    <div class="row">
                        
                        <div class="col-md-4">
                            <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($datafiltro['datade']) }}"  />
                        </div>

                        <div class="col-md-4">
                            <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($datafiltro['dataate']) }}"  />
                        </div>

                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light" name="action" value="filtrar">Filtrar</button> 
                        </div>
                
                        <div class="col-md-2">
                            <input type="image" name="" src="images/icons/export_pdf_icon.png" onclick=downloadPDF() width="40" alt="Exportar em PDF">  
                            <input type="image" name="" src="images/icons/export_xls_icon.png" onclick=downloadXLS() width="40" alt="Exportar em CSV">  
                        </div>
                    </div>
                </form>
            </div>
            </div>
        </div>
    </div>
    


    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7">Período: {{ $datafiltro['datade'] }} a {{ $datafiltro['dataate'] }}</div>
                        <div class="col-md-5 text-right {{ ($extrato['Balance']<0)?'text-danger':'text-success' }}">Saldo: R$ {{ formatMoneyBr($extrato['Balance']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div>    

    @foreach(json_decode($extrato['Entry']) as $ext)
        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">
                <div class="card-date">{{ entryDate2dataHora($ext->EntryDate) }}</div>
                <div class="card">
                    <!-- CARD HEADER -->
                    <div class="card-header d-flex justify-content-between pb-0">
                        <div class="row">
                            {{ $ext->Details }}                            
                        </div>
                    </div>
                    <!-- /CARD HEADER -->
                    <div class="card-content">
                        <div class="card-body">
                            @if($ext->Type == 'InternalDischargeAccount')
                                <?php $verificaAdiantamento = verificaAdiantamento($ext->DocumentNumber) ?>
                                @if($verificaAdiantamento)
                                    <div class="row">
                                        <div class="col-12 text-left">
                                            <small class="text-primary">Adiantamento de saldo para pagamento</small>
                                        </div>                                
                                    </div>
                                @endif
                            @endif
                            <div class="row">
                                <div class="col-2  text-left">
                                    @if(!empty($ext->ReceiptUrl))
                                        <a href="{{ $ext->ReceiptUrl }}" target="_blank"><span class="text-danger"><i class="fa fa-file-pdf-o"></i></span></a>
                                    @endif
                                </div>
                                <div class="col-10  text-right" tydn="{{ $ext->Type.'-'.$ext->DocumentNumber }}">
                                    <h3 class="text-bold-500 {{ ($ext->EntryValue<0)?'text-danger':'text-success' }}">R$ {{ formatMoneyBr($ext->EntryValue) }}</h2>
                                </div>
                            </div>
                            <?php $verificaUtilizadoAdiantamento = verificaUtilizadoAdiantamento($ext->DocumentNumber, $ext->Type) ?>
                            @if($verificaUtilizadoAdiantamento)
                                <div class="row">
                                    <div class="col-12 text-right">
                                        <small class="text-muted">Utilizados R${{ formatMoneyBr($verificaUtilizadoAdiantamento) }} de adiantamento de saldo</small>
                                    </div>                                
                                </div>
                            @endif
                        </div>
                    </div>
                </div>{{-- card --}}
            </div>{{-- col-8 --}}
        </div>{{-- row --}}
    @endforeach

    @if($client->allowlimit==1)
        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">    
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12 text-center">Saldo a compensar: <strong>R$ {{ formatMoneyBr($saldocompensar) }}</strong></div>
                        </div>
                    </div>    
                </div>    
            </div>    
        </div>
    @endif

    <br>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="divider divider-dark">
                <div class="divider-text font-large-1">Lançamentos futuros</div>
            </div>
        </div>
    </div>

    @foreach($lancamentosfuturos as $fut)
        <div class="row justify-content-md-center">
            <div class="col-md-8 col-12">
                <div class="card-date">{{ detectDateFormatOutputDateBr($fut->paymentdate) }}</div>
                <div class="card">
                    <!-- CARD HEADER -->
                    <div class="card-header d-flex justify-content-between pb-0">
                        <div class="row">
                            {{ $fut->type }}
                        </div>
                    </div>
                    <!-- /CARD HEADER -->
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-2  text-left">
                                </div>
                                <div class="col-10  text-right" tydn="{{ $fut->documentnumber }}">
                                    <h3 class="text-bold-500">R$ {{ formatMoneyBr($fut->value) }}</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>{{-- card --}}
            </div>{{-- col-8 --}}
        </div>{{-- row --}}
    @endforeach

</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        function downloadPDF(){

            var dataDe = document.getElementById('datade').value;
            var dataAte = document.getElementById('dataate').value;

            var url = "/extratopdf?datade="+dataDe+"&dataate="+dataAte;
            

            if(validaForm()){
                window.open(url, '_blank').focus();
                //window.open(url);
            }
        }

        function downloadCSV(){

            var dataDe = document.getElementById('datade').value;
            var dataAte = document.getElementById('dataate').value;

            var url = "/extratocsv?datade="+dataDe+"&dataate="+dataAte;

            if(validaForm())
                window.open(url);

        }

        function downloadXLS(){

            var dataDe = document.getElementById('datade').value;
            var dataAte = document.getElementById('dataate').value;

            var url = "/extratoxls?datade="+dataDe+"&dataate="+dataAte;

            if(validaForm()){

                window.open(url);
            }
        }



        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection
