<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeTransferlogsAddSchedule extends Migration
{
	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('transferlogs', function (Blueprint $table) {
			$table->smallInteger('is_scheduled')
				->default(0)
				->after('datasent');

			$table->smallInteger('scheduled_status')
				->nullable()
				->after('is_scheduled');

			$table->dateTime('cancellation_date')->nullable()->after('scheduled_status');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('transferlogs', function (Blueprint $table) {
			$table->dropColumn('is_scheduled');
			$table->dropColumn('scheduled_status');
			$table->dropColumn('cancellation_date');
		});
	}
}
