<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ClientsAddD0AutoFields extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->string('d0automatic', 1)
                ->default(0)
                ->comment('D+0 automatico ou nao')
                ->after('monthlyfeedueday');

            $table->time('d0time')
                ->comment('Horario marcado para o D+0 automatico')
                ->after('d0automatic');

            $table->string('d1automatic', 1)
                ->default(0)
                ->comment('D+1 automatico ou nao')
                ->after('d0time');

            $table->time('d1time')
                ->comment('Horario marcado para o D+1 automatico')
                ->after('d1automatic');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->dropColumn('d0automatic');
            $table->dropColumn('d0time');
            $table->dropColumn('d1automatic');
            $table->dropColumn('d1time');
        });
    }
}
