<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class MultisafesAddFieldMonthlyfee extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('multisafes', function (Blueprint $table) {
            $table->float('monthlyfee')
                ->default(0)
                ->comment('valor mensalidade')
                ->after('availablelimit');

            $table->float('monthlyfeeautodebit')
                ->default(0)
                ->comment('debito automatico valor mensalidade')
                ->after('monthlyfee');

            $table->string('monthlyfeedueday', 2)
                ->default('05')
                ->comment('dia do vencimento da mensalidade')
                ->after('monthlyfeeautodebit');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('multisafes', function (Blueprint $table) {
            $table->dropColumn('monthlyfee');
            $table->dropColumn('monthlyfeeautodebit');
            $table->dropColumn('monthlyfeedueday');
        });
    }
}
