<?php

use App\Usedavailablelimit;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class UsedavailablelimitsAddDuedate extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('usedavailablelimits', function (Blueprint $table) {
            $table->datetime('duedate')->nullable()->after('emission');
        });

        Usedavailablelimit::whereNull('duedate')->update(['duedate' => DB::raw('DATE_ADD(emission, INTERVAL 1 DAY)')]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('usedavailablelimits', function (Blueprint $table) {
            $table->dropColumn('duedate');
        });
    }
}
