<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransfermanagersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transfermanagers', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            
            $table->integer('user_id')->unsigned();
            $table->integer('client_id')->unsigned();
            $table->string('taxnumber',20)->default(0);
            $table->datetime('actiondate');
            $table->string('documento',255)->nullable()->default('');
            $table->string('nome',255)->nullable()->default('');
            $table->string('banco',255)->nullable()->default('');
            $table->string('agencia',255)->nullable()->default('');
            $table->string('conta',255)->nullable()->default('');
            $table->string('digito',255)->nullable()->default('');
            $table->string('tipoconta',255)->nullable()->default('');
            $table->string('valor',255)->nullable()->default('');
            $table->string('ratevalue',255)->nullable()->default('');
            $table->string('identificador',255)->nullable()->default('');
            $table->string('success',1)->default('');
            $table->string('documentnumber',255)->nullable()->default('');
            $table->text('url')->nullable();
            $table->string('alreadyexists',1)->nullable()->default(0);
            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);

            $table->string('identifier',255)->nullable();
            $table->string('moneytransferdocumentnumber',255)->nullable();
            $table->string('entryid',255)->nullable();
            $table->string('totalvalue',255)->nullable();
            $table->string('status',255)->nullable();
            $table->string('paymentdate',255)->nullable();
            $table->string('returncode',255)->nullable();
            $table->string('bankcode',255)->nullable();
            $table->string('bankbranch',255)->nullable();
            $table->string('bankaccount',255)->nullable();
            $table->string('bankaccountdigit',255)->nullable();
            $table->string('receipturl',255)->nullable();
            $table->string('name',255)->nullable();
            $table->string('sendernamebank',255)->nullable();
            $table->string('sendercodebank',255)->nullable();
            $table->string('senderbranch',255)->nullable();
            $table->string('senderaccount',255)->nullable();
            $table->string('senderaccountdigit',255)->nullable();
            $table->longtext('datasent')->nullable();
            $table->longtext('webhookpayload')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transfermanagers');
    }
}
