<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLogscurlTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logscurl', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('user_id')->index();
            $table->integer('role_id')->unsigned()->default(2)->index();
            $table->integer('client_id')->index();
            $table->string('taxnumber', 20)->default(0)->index();
            $table->string('success', 1)->nullable()->index();
            $table->longText('message')->nullable();
            $table->string('documentnumber',255)->nullable()->default('')->index();
            $table->string('alreadyexists',1)->nullable()->default(0);
            $table->longText('validation')->nullable();
            $table->longText('entry')->nullable();
            $table->string('balance',255)->nullable();
            $table->text('url')->nullable();
            $table->longText('datasent')->nullable();
            $table->longText('datareceived')->nullable();
            $table->datetime('sentdate')->nullable();
            $table->datetime('receiveddate')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('logscurl');
    }
}
