<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCollectsmapTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('collectsmap', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->integer('user_id');
            $table->integer('client_id')->index();
            $table->string('taxnumber',20)->default(0)->index();
            $table->datetime('emission')->nullable();
            $table->float('realcollectedvalue')->default(0);
            $table->float('transferedvalue')->default(0);
            $table->float('paymentvalue')->default(0);
            $table->float('differencevalue')->default(0);
            $table->integer('closed')->default(0)->comment('finalizado');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('collectsmap');
    }
}
