<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UsedavailablelimitsAddFieldsCharge extends Migration
{
    public function up()
    {
        Schema::table('usedavailablelimits', function (Blueprint $table) {
            $table->integer('daysused')->default(0)->comment('dias utilizado')->after('status');
            $table->float('interestvalue')->default(0)->comment('juros - atualizado diariamente')->after('daysused');
            $table->integer('paid')->default(0)->comment('quitado')->after('interestvalue');
            $table->datetime('paymentdate')->nullable()->comment('data quitacao')->after('paid');
        });
    }

    public function down()
    {
        Schema::table('usedavailablelimits', function (Blueprint $table) {
            $table->dropColumn('daysused');
            $table->dropColumn('interestvalue');
            $table->dropColumn('paid');
            $table->dropColumn('paymentdate');
        });
    }
}
