<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsedavailablelimitsTable extends Migration
{
    public function up()
    {
        Schema::create('usedavailablelimits', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->integer('user_id');
            $table->integer('client_id');
            $table->string('taxnumber',20)->default(0);
            $table->datetime('emission')->nullable();
            $table->float('availablelimit')->default(0);
            $table->float('requestedvalue')->default(0);
            $table->string('transactiontype',255)->nullable();
            $table->string('documentnumber',255)->nullable();
            $table->timestamps();
        });
    }



    public function down()
    {
        Schema::dropIfExists('usedavailablelimits');        
    }
}
