<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class WebhookAdjustmentsTransferlogs extends Migration
{
    public function up()
    {
        Schema::create('moneytransfers', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->integer('client_id')->unsigned();
            $table->string('taxnumber',20)->default(0);
            $table->datetime('emission');


            $table->string('fromtaxnumber',255)->nullable();
            $table->string('frombank',255)->nullable();
            $table->string('frombankbranch',255)->nullable();
            $table->string('frombankaccount',255)->nullable();
            $table->string('frombankaccountdigit',255)->nullable();
            $table->string('totaxnumber',255)->nullable();
            $table->string('toname',255)->nullable();
            $table->string('bank',255)->nullable();
            $table->string('bankbranch',255)->nullable();
            $table->string('bankaccount',255)->nullable();
            $table->string('bankaccountdigit',255)->nullable();
            $table->string('accounttype',255)->nullable();
            $table->float('value')->default(0)->nullable();
            $table->float('ratevalue')->default(0)->nullable();
            $table->string('identifier',255)->nullable();
            $table->string('ratevaluetype',255)->nullable();
            $table->string('tags',255)->nullable();
            $table->string('description',255)->nullable();
            $table->string('paymentdate',255)->nullable();
            $table->string('feepayertaxnumber',255)->nullable();
            $table->string('feepayerfullname',255)->nullable();
            $table->string('feepayermail',255)->nullable();
            $table->string('feepayerphone',255)->nullable();
            $table->string('feepayerbank',255)->nullable();
            $table->string('feepayerbankbranch',255)->nullable();
            $table->string('feepayerbankaccount',255)->nullable();
            $table->string('feepayerbankaccountdigit',255)->nullable();
            $table->string('documentnumber',255)->nullable();
            $table->string('moneytransferdocumentnumber',255)->nullable();
            $table->string('entryid',255)->nullable();
            $table->float('totalvalue')->default(0)->nullable();
            $table->string('status',255)->nullable();
            $table->string('returncode',255)->nullable();
            $table->string('bankcode',255)->nullable();
            $table->string('receipturl',255)->nullable();
            $table->string('name',255)->nullable();
            $table->string('sendernamebank',255)->nullable();
            $table->string('sendercodebank',255)->nullable();
            $table->string('senderbranch',255)->nullable();
            $table->string('senderaccount',255)->nullable();
            $table->string('senderaccountdigit',255)->nullable();

            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);
            $table->longtext('datasent')->nullable();
            $table->longtext('webhookpayload')->nullable();
            $table->timestamps();

        });

        Schema::table('transferlogs', function (Blueprint $table) {
            $table->string('identifier',255)->nullable()->after('valorlimiteespecial');
            $table->string('moneytransferdocumentnumber',255)->nullable()->after('identifier');
            $table->string('entryid',255)->nullable()->after('moneytransferdocumentnumber');
            $table->string('totalvalue',255)->nullable()->after('entryid');
            $table->string('status',255)->nullable()->after('totalvalue');
            $table->string('paymentdate',255)->nullable()->after('status');
            $table->string('returncode',255)->nullable()->after('paymentdate');
            $table->string('bankcode',255)->nullable()->after('returncode');
            $table->string('bankbranch',255)->nullable()->after('bankcode');
            $table->string('bankaccount',255)->nullable()->after('bankbranch');
            $table->string('bankaccountdigit',255)->nullable()->after('bankaccount');
            $table->string('receipturl',255)->nullable()->after('bankaccountdigit');
            $table->string('name',255)->nullable()->after('receipturl');
            $table->string('sendernamebank',255)->nullable()->after('name');
            $table->string('sendercodebank',255)->nullable()->after('sendernamebank');
            $table->string('senderbranch',255)->nullable()->after('sendercodebank');
            $table->string('senderaccount',255)->nullable()->after('senderbranch');
            $table->string('senderaccountdigit',255)->nullable()->after('senderaccount');
            $table->longtext('datasent')->nullable()->after('senderaccountdigit');
            $table->longtext('webhookpayload')->nullable()->after('datasent');
        });

        Schema::table('darfpayments', function (Blueprint $table) {
            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);

        });

        Schema::table('darjpayments', function (Blueprint $table) {
            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);
        });

        Schema::table('fgtspayments', function (Blueprint $table) {
            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);
            $table->string('ratevalue',60)->default(0);
            $table->string('duedate',60)->nullable();
            $table->string('referencenumber',255)->nullable();

        });

        Schema::table('garepayments', function (Blueprint $table) {
            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);

        });

        Schema::table('gpspayments', function (Blueprint $table) {
            $table->string('limiteespecial',1)->default(0);
            $table->string('valorlimiteespecial',60)->default(0);

        });


    }


    public function down()
    {
       Schema::dropIfExists('moneytransfers');

       Schema::table('transferlogs', function (Blueprint $table)
        {
            $table->dropColumn('identifier');
            $table->dropColumn('moneytransferdocumentnumber');
            $table->dropColumn('entryid');
            $table->dropColumn('totalvalue');
            $table->dropColumn('status');
            $table->dropColumn('paymentdate');
            $table->dropColumn('returncode');
            $table->dropColumn('bankcode');
            $table->dropColumn('bankbranch');
            $table->dropColumn('bankaccount');
            $table->dropColumn('bankaccountdigit');
            $table->dropColumn('receipturl');
            $table->dropColumn('name');
            $table->dropColumn('sendernamebank');
            $table->dropColumn('sendercodebank');
            $table->dropColumn('senderbranch');
            $table->dropColumn('senderaccount');
            $table->dropColumn('senderaccountdigit');
            $table->dropColumn('datasent');
            $table->dropColumn('webhookpayload');
            
        });

       Schema::table('darfpayments', function (Blueprint $table) {
            $table->dropColumn('limiteespecial');
            $table->dropColumn('valorlimiteespecial');
        });

        Schema::table('darjpayments', function (Blueprint $table) {
            $table->dropColumn('limiteespecial');
            $table->dropColumn('valorlimiteespecial');
        });

        Schema::table('fgtspayments', function (Blueprint $table) {
            $table->dropColumn('limiteespecial');
            $table->dropColumn('valorlimiteespecial');
            $table->dropColumn('ratevalue');
            $table->dropColumn('duedate');
            $table->dropColumn('referencenumber');
        });

        Schema::table('garepayments', function (Blueprint $table) {
           $table->dropColumn('limiteespecial');
            $table->dropColumn('valorlimiteespecial');
        });

        Schema::table('gpspayments', function (Blueprint $table) {
            $table->dropColumn('limiteespecial');
            $table->dropColumn('valorlimiteespecial');
        });
        
    }
}
