<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateGpspaymentsTable extends Migration
{
    public function up()
    {
        Schema::create('gpspayments', function (Blueprint $table)
        {
            $table->increments('id')->unsigned();
            $table->integer('user_id');
            $table->integer('client_id');
            $table->string('taxnumber',20)->default(0);
            $table->datetime('emission')->nullable();
            $table->string('contributortaxnumber',255)->nullable();
            $table->float('principalvalue')->default(0);
            $table->float('fineinterestvalue')->default(0);
            $table->float('othervalues')->default(0);
            $table->float('ratevalue')->default(0);
            $table->string('paymentdate',20)->nullable();
            $table->string('ratevaluetype',1)->nullable();
            $table->string('description',255)->nullable();
            $table->string('identifier',255)->nullable();
            $table->string('paymentcode',255)->nullable();
            $table->string('jurisdictiondate',255)->nullable();
            $table->string('status',1)->default('0');
            $table->string('documentnumber',255)->nullable();
            $table->string('alreadyexists',1)->default('0');


            $table->string('referencenumber',255)->nullable();
            $table->float('interestvalue')->default(0);
            $table->float('totalvalue')->default(0);
            $table->string('wasauthorized',1)->default('0');
            $table->string('paymentdate2',20)->nullable();
            $table->string('namecontributor',255)->nullable();
            $table->string('paymentauthentication',255)->nullable();
            $table->string('receipturl',255)->nullable();
            $table->string('returnmessage',255)->nullable();
            $table->string('returncode',255)->nullable();
            $table->string('sendernamebank',255)->nullable();
            $table->string('sendercodebank',15)->nullable();
            $table->string('senderbranch',15)->nullable();
            $table->string('senderaccount',15)->nullable();
            $table->string('senderaccountdigit',15)->nullable();
            $table->longtext('datasent')->nullable();
            $table->timestamps();
        });
    }



    public function down()
    {
        Schema::dropIfExists('gpspayments');        
    }
}
