<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBilleterrorsTable extends Migration
{
	public function up()
	{
		Schema::create('billeterrors', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->integer('user_id');
			$table->integer('client_id');
			$table->string('taxnumber',20)->default(0);
			$table->string('customername',255)->nullable(0);
			$table->string('customertaxnumber',20)->nullable();
			$table->string('totalvalue',20)->nullable(0);
			$table->datetime('emission')->nullable();
			$table->string('message',255)->nullable()->default('');
			$table->longtext('datasent')->nullable();
			$table->longtext('validation')->nullable();
			$table->timestamps();
		});

		Schema::dropIfExists('failed_jobs');
	}



	public function down()
	{
		Schema::dropIfExists('billeterrors');
		
	}
}
