<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBilletsTable extends Migration
{
	public function up()
	{
		Schema::create('billets', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->integer('user_id');
			$table->integer('client_id');
			$table->integer('clientcontact_id')->default(0);
			$table->string('taxnumber',20)->default(0);
			$table->datetime('emission')->nullable();
			$table->string('customername',255)->nullable();
			$table->string('customertaxnumber',255)->nullable();
			$table->string('customermail',255)->nullable();
			$table->string('customerphone',255)->nullable();
			$table->string('addressline1',255)->nullable();
			$table->string('addressline2',255)->nullable();
			$table->string('neighborhood',255)->nullable();
			$table->string('city',255)->nullable();
			$table->string('state',255)->nullable();
			$table->string('zipcode',255)->nullable();
			$table->string('mailtosend',255)->nullable();
			$table->string('phonetosend',255)->nullable();
			$table->string('externalnumber',255)->nullable();
			$table->string('identifier',255)->nullable();
			$table->string('comments',255)->nullable();
			$table->string('duedate',255)->nullable();
			$table->string('totalvalue',255)->nullable();
			$table->string('finedate',255)->nullable();
			$table->string('finepercent',255)->nullable();
			$table->string('finevalue',255)->nullable();
			$table->string('interestpercent',255)->nullable();
			$table->string('interestvalue',255)->nullable();
			$table->string('discountdate',255)->nullable();
			$table->string('discountvalue',255)->nullable();
			$table->string('rebatevalue',255)->nullable();
			$table->string('documentnumber',255)->nullable()->default('');
			$table->string('entryid',255)->nullable()->default('');
			$table->text('url')->nullable();
			$table->string('alreadyexists',1)->nullable()->default(0);
			$table->longtext('datasent')->nullable();
			$table->longtext('boleto')->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('billets');
	}
}
