<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeClientsAddRates extends Migration
{
	public function up()
	{
		Schema::table('clients', function (Blueprint $table)
		{
			$table->string('customrates',1)->default(0)->after('availablelimit');
			$table->float('ratevalue')->default(0)->after('customrates');
			$table->float('ratevalueted')->default(0)->after('ratevalue');
			$table->float('ratevaluelimit')->default(0)->after('ratevalueted');
			$table->string('dailyinterest',1)->default(0)->after('ratevaluelimit');
			$table->float('dailyinterestvalue')->default(0)->after('dailyinterest');
			$table->float('dailyinterestpercentage')->default(0)->after('dailyinterestvalue');
		});
	}



	public function down()
	{
		Schema::table('clients', function (Blueprint $table)
		{
			$table->dropColumn('customrates');
			$table->dropColumn('ratevalue');
			$table->dropColumn('ratevalueted');
			$table->dropColumn('ratevaluelimit');
			$table->dropColumn('dailyinterest');
			$table->dropColumn('dailyinterestvalue');
			$table->dropColumn('dailyinterestpercentage');
		});
	}
}
