<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePaymentlogsTable extends Migration
{
	public function up()
	{
		Schema::create('paymentlogs', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->integer('user_id');
			$table->integer('client_id');
			$table->string('taxnumber',20)->default(0);
			$table->datetime('actiondate')->nullable();
			$table->date('duedate')->nullable();
			$table->date('paymentdate')->nullable();
			$table->string('transactionnumber',255)->nullable();
			$table->string('method',255)->nullable();
			$table->string('identifier',255)->nullable();
			$table->string('barcode',255)->nullable();
			$table->longText('datasent')->nullable();
			$table->string('success',1)->default('1');
			$table->longText('message')->nullable();
			$table->longText('validation')->nullable();
			$table->text('entryid')->nullable();
			$table->text('url')->nullable();
			$table->float('value')->default(0);
			$table->float('discount')->default(0);
			$table->float('extravalue')->default(0);
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('paymentlogs');
	}
}
