<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeTransactionlogsAddFields extends Migration
{
	public function up()
	{
		Schema::table('transactionlogs', function (Blueprint $table)
		{
			$table->integer('user_id')->after('id');
			$table->integer('client_id')->after('user_id');
			$table->string('taxnumber',20)->default(0)->after('client_id');
			$table->datetime('actiondate')->nullable()->after('taxnumber');
		});
	}



	public function down()
	{
		Schema::table('transactionlogs', function (Blueprint $table)
		{
			$table->dropColumn('user_id');
			$table->dropColumn('client_id');
			$table->dropColumn('taxnumber');
			$table->dropColumn('actiondate');
		});
	}
}
