<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDetailedaccountsTable extends Migration
{
	public function up()
	{
		Schema::create('detailedaccounts', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->string('businessunitid',100)->index();
			$table->string('personname',255)->nullable();
			$table->string('taxnumber',45)->nullable()->comment('Cpf/cnpj da empresa');
			$table->string('phonenumber',45)->nullable();
			$table->string('companytype',1)->nullable()->comment('0 - Para SA (Sociedade Annima), 1 - Para LTDA (Sociedade limitada), 2 para MEI (Micro Empreendedor Individual).');
			$table->string('companyactivity',255)->nullable();
			$table->string('constitutiondate',45)->nullable();
			$table->string('representativename',255)->nullable();
			$table->string('representativetaxnumber',45)->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('detailedaccounts');
	}
}
