<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientsTable extends Migration
{
	public function up()
	{
		Schema::create('clients', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->string('taxnumber',45)->comment('Cpf/cnpj');
			$table->string('businessunitid',60);
			$table->string('mail',60)->nullable();
			$table->string('phone',30)->nullable();
			$table->string('nickname',100)->nullable();
			$table->string('name',100)->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('clients');
	}
}
