<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAddressesTable extends Migration
{
	public function up()
	{
		Schema::create('addresses', function (Blueprint $table)
		{
			$table->increments('id')->unsigned();
			$table->string('businessunitid',100)->index();
			$table->string('addresstype',1)->nullable()->comment('0 - Para Comercial e 1 para Residencial.');
			$table->string('addressline',255)->nullable();
			$table->string('complement',255)->nullable();
			$table->string('neighborhood',255)->nullable();
			$table->string('cityname',255)->nullable();
			$table->string('state',255)->nullable();
			$table->string('zipcode',15)->nullable();
			$table->string('addressline2',45)->nullable();
			$table->string('country',255)->nullable();
			$table->timestamps();
		});
	}



	public function down()
	{
		Schema::dropIfExists('addresses');
	}
}
