<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class Role extends Model
{
	use Notifiable;
	protected $table = 'roles';

	protected $fillable = [
		'role'
	];

	public function users()
	{
		return $this->hasMany(User::class);
	}

	public function resources()
	{
		return $this->belongsToMany(Resource::class);
	}
	
}
