<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

use Mail;

class EnviaMailAnexo extends Mailable
{
    use Queueable, SerializesModels;

    public $nomedestinatario;
    public $maildestinatario;
    public $assunto;
    public $mensagem;
    public $anexo;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($nomedestinatario, $maildestinatario, $assunto, $mensagem, $anexo)
    {
        $this->nomedestinatario = $nomedestinatario;
        $this->maildestinatario = $maildestinatario;
        $this->assunto = $assunto;
        $this->mensagem = $mensagem;
        $this->anexo = $anexo;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data = array(
                    'nome'=>$this->nomedestinatario,
                    'email'=>$this->maildestinatario,
                    'mensagem'=>$this->mensagem,
                    'anexo'=>$this->anexo
                );

        return $this->view('emails.enviamail',compact('data'))
                    ->from('naoresponda@ssgbank.com.br','SSGBank Website')
                    ->to($this->maildestinatario, $this->nomedestinatario)
                    ->attach($this->anexo)
                    ->subject('[SSG Bank] '.$this->assunto);
    }
}
