<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

use Mail;

class EnviaMail extends Mailable
{
    use Queueable, SerializesModels;

    public $nomedestinatario;
    public $maildestinatario;
    public $assunto;
    public $mensagem;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($nomedestinatario, $maildestinatario, $assunto, $mensagem)
    {
        $this->nomedestinatario = $nomedestinatario;
        $this->maildestinatario = $maildestinatario;
        $this->assunto = $assunto;
        $this->mensagem = $mensagem;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data = array(
                    'nome'=>$this->nomedestinatario,
                    'email'=>$this->maildestinatario,
                    'mensagem'=>$this->mensagem
                );

        return $this->view('emails.enviamail',compact('data'))
                    ->from('naoresponda@ssgbank.com.br','SSGBank Website')
                    ->to($this->maildestinatario, $this->nomedestinatario)
                    ->subject('[SSG Bank] '.$this->assunto);
    }
}
