<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

use Illuminate\Http\Request;
use Mail;

class ContatoFormTi extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(Request $request)
    {
        $data = array(
                    'nome'=>$request->nome,
                    'email'=>$request->email,
                    'telefone'=>$request->telefone,
                    'mensagem'=>$request->mensagem
                );
   	
        return $this->view('emails.contatoform',compact('data'))
                    ->from('naoresponda@ssgbank.com.br','SSGBank Website')
                    ->replyTo($request->email,$request->nome)
                    ->to('alexandre.amorim@smartsafebrasil.com.br', 'SSG Bank Contato')
                    ->subject('[SSG Bank] Mensagem do site');

    }
}
