<?php

namespace App\Http\Middleware;

use Closure;
use JWTAuth;
use Exception;
use Tymon\JWTAuth\Http\Middleware\BaseMiddleware;

class JwtMiddleware extends BaseMiddleware
{

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            $user = JWTAuth::parseToken()->authenticate();
        } catch (Exception $e) {
            if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenInvalidException){
                return response()->json(['success'=>false, 'status' => 'Token is Invalid', 'message' => 'Houve um problema com a autenticação']);
            }else if ($e instanceof \Tymon\JWTAuth\Exceptions\TokenExpiredException){
                return response()->json(['success'=>false, 'status' => 'Token is Expired', 'message' => 'Houve um problema com a autenticação']);
            }else{
                return response()->json(['success'=>false,'status' => 'Authorization Token not found','message' => 'Houve um problema com a autenticação']);
            }
        }
        return $next($request);
    }
}