<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use Symfony\Component\Process\Process;

use App\Client;
use App\User;
use App\Billet;
use App\Darfpayment;
use App\Darjpayment;
use App\Fgtspayment;
use App\Garepayment;
use App\Gpspayment;
use App\Transferlog;
use App\Transactionlog;
use App\Barcodepayment;

class WebhookController extends Controller
{
    // TODO autenticação
    


    public function cobrancaboletos(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "documentnumber": "5465662",
            "identifier": 10,
        **    "boletodocumentnumber": 10,
            "entryid": 10,
            "interestvalue": 10,
            "finevalue": 10,
            "totalvalue": 10,
        **    "status": "paid",
        **    "paymentdate": "2017/12/31",
        **    "bankcode": 654,
            "discountvalue": 0,
        **    "iofvalue": 10,
        **    "returncode": 244,
        **    "paidvalue": 2434,
        **    "creditdate": "2018/03/30",
        **    "occurrencedate": "2018/03/30",
        **    "occurrencemotive": "none",
        **    "barcode": "84562578951236548795632154896532154897632154",
        **    "digitableline": "898854221000540360089074005800400600448000001400",
        **    "partnerid": 99,
        **    "othervalues": 4,
        **    "method": "boleto",
        **    "businessunitid": 988
        }
        */

        $boleto = Billet::select(
                                'id',
                                'boletodocumentnumber',
                                'entryid',
                                'interestvalue',
                                'finevalue',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'bankcode',
                                'discountvalue',
                                'iofvalue',
                                'returncode',
                                'paidvalue',
                                'creditdate',
                                'occurrencedate',
                                'occurrencemotive',
                                'barcode',
                                'digitableline',
                                'partnerid',
                                'othervalues',
                                'method',
                                'businessunitid',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',somenteNumeros($request->input('DocumentNumber')))
                            ->first();

        if(!$boleto) return response()->json(['Success' => false, 'Message'=>'DocumentNumber e/ou Identifier não encontrado(s)'], 412);
       
        $boleto->boletodocumentnumber = $request->input('BoletoDocumentNumber');
        $boleto->entryid = $request->input('EntryId');
        $boleto->interestvalue = $request->input('InterestValue');
        $boleto->finevalue = $request->input('FineValue');
        $boleto->totalvalue = $request->input('TotalValue');
        $boleto->status = $request->input('Status');
        $boleto->paymentdate = $request->input('PaymentDate');
        $boleto->bankcode = $request->input('BankCode');
        $boleto->discountvalue = zeroNull($request->input('DiscountValue'));
        $boleto->iofvalue = zeroNull($request->input('IofValue'));
        $boleto->returncode = $request->input('ReturnCode');
        $boleto->paidvalue = $request->input('PaidValue');
        $boleto->creditdate = $request->input('CreditDate');
        $boleto->occurrencedate = $request->input('OccurrenceDate');
        $boleto->occurrencemotive = $request->input('OccurrenceMotive');
        $boleto->barcode = $request->input('Barcode');
        $boleto->digitableline = $request->input('DigitableLine');
        $boleto->partnerid = $request->input('PartnerId');
        $boleto->othervalues = $request->input('OtherValues');
        $boleto->method = $request->input('Method');
        $boleto->businessunitid = $request->input('BusinessUnitId');
        $boleto->webhookpayload = $request->input();

        $boleto->update();

        $sucesso = (!$boleto)?false:true;
        $protocolo = (!$boleto)?400:200;
        $mensagem = (!$boleto)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);

    }


    public function pagamentocontas(Request $request) {
        // TODO: PaymentSubType  função para os tipos

        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
         **   "documentnumber": "11378013794",
            "identifier": 5642,
         **   "entryid": 5642,
         **   "interestvalue": 12345,
         **   "finevalue ": 12345,
         **   "totalvalue": 12345,
         **   "status": "paid",
            "paymentdate": "2018/03/30",
         **   "bankconcessionarefavored ": 12345,
            "discountvalue ": 12345,
         **   "occurrencedate": "2018/03/30",
         **   "returncode": 12345,
            "barcode": "000000000000000100001",
            "duedate": "2018/03/31",
            "beneficiarytaxnumber": "04685457854",
            "beneficiaryname": "josé ticio",
            "guarantortaxnumber": "024587652019",
            "guarantorname": "silva ticio",
            "payertaxnumber": "jose silva",
         **   "receipturl": "pdf do comprovante para transferência e pagamento de contas/tributos",
         **   "paymentauthentication": "8995ew4%$d3s54523aewdasdasd",
         **   "paymentprotocol": "8654wersdf",
         **  "paymentsubtype": "iptu",
         **   "sendernamebank": "itau",
         **   "sendercodebank": "341",
         **   "senderbranch": "1234",
         **   "senderaccount": "14555",
          **  "senderaccountdigit": "1"
        }
        */

        $pagamento = Barcodepayment::select(
                                'id',
                                'entryid',
                                'interestvalue',
                                'finevalue',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'bankconcessionarefavored',
                                'discountvalue',
                                'occurrencedate',
                                'returncode',
                                'barcode',
                                'duedate',
                                'beneficiarytaxnumber',
                                'beneficiaryname',
                                'guarantortaxnumber',
                                'guarantorname',
                                'payertaxnumber',
                                'receipturl',
                                'paymentauthentication',
                                'paymentprotocol',
                                'paymentsubtype',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',somenteNumeros($request->input('DocumentNumber')))
                            ->first();

        if(!$pagamento) return response()->json(['Success' => false, 'Message'=>'DocumentNumber e/ou Identifier não encontrado(s)'], 412);
       
        $pagamento->entryid = $request->input('EntryId');
        $pagamento->interestvalue = $request->input('InterestValue');
        $pagamento->finevalue = $request->input('FineValue');
        $pagamento->totalvalue = $request->input('TotalValue');
        $pagamento->status = $request->input('Status');
        $pagamento->paymentdate = $request->input('PaymentDate');
        $pagamento->bankconcessionarefavored = $request->input('BankConcessionareFavored');
        $pagamento->discountvalue = zeroNull($request->input('DiscountValue'));
        $pagamento->occurrencedate = $request->input('OccurrenceDate');
        $pagamento->returncode = $request->input('ReturnCode');
        $pagamento->barcode = $request->input('Barcode');
        $pagamento->duedate = $request->input('DueDate');
        $pagamento->beneficiarytaxnumber = $request->input('BeneficiaryTaxNumber');
        $pagamento->beneficiaryname = $request->input('BeneficiaryName');
        $pagamento->guarantortaxnumber = $request->input('GuarantorTaxNumber');
        $pagamento->guarantorname = $request->input('GuarantorName');
        $pagamento->payertaxnumber = $request->input('PayerTaxNumber');
        $pagamento->receipturl = $request->input('ReceiptUrl');
        $pagamento->paymentauthentication = $request->input('PaymentAuthentication');
        $pagamento->paymentprotocol = $request->input('PaymentProtocol');
        $pagamento->paymentsubtype = $request->input('PaymentSubType');
        $pagamento->sendernamebank = $request->input('SenderNameBank');
        $pagamento->sendercodebank = $request->input('SenderCodeBank');
        $pagamento->senderbranch = $request->input('SenderBranch');
        $pagamento->senderaccount = $request->input('SenderAccount');
        $pagamento->senderaccountdigit = $request->input('SenderAccountDigit');

        $pagamento->webhookpayload = $request->input();

        $pagamento->update();

        $sucesso = (!$pagamento)?false:true;
        $protocolo = (!$pagamento)?400:200;
        $mensagem = (!$pagamento)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);

    }


    public function darf(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "documentnumber": "11378013794",
            "identifier": 5642,
        ***    "entryid": 12345,
            "totalvalue": 12345,
            "status": "paid",
            "paymentdate": "2018/03/30",
            "returncode ": 65432,
            "returnmessage": " mensagem",
            "receipturl": "www.url.com.br",
            "coderevenue": 341,
            "contributortaxnumber": "41590989823",
            "finevalue": 54,
            "interestvalue": 4,
            "valuerecipegrossaccumulated ": 54,
            "percentagerecipegrossaccumulated": 4,
            "duedate": "2018/03/30",
        ***    "contributorname": "josé silva",
            "calculationperiod": "2018/03/30",
            "referencenumber": 405,
            "paymentauthentication": 405,
        ***    "paymentprotocol": 4578,
            "sendernamebank": "itau",
            "sendercodebank": "341",
            "senderbranch": "1234",
            "senderaccount": "14555",
            "senderaccountdigit": "1"
        }
        */

        $darf = Darfpayment::select(
                                'id',
                                'entryid',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'returncode',
                                'returnmessage',
                                'receipturl',
                                'coderevenue',
                                'contributortaxnumber',
                                'finevalue',
                                'interestvalue',
                                'valuerecipegrossaccumulated',
                                'percentagerecipegrossaccumulated',
                                'duedate',
                                'contributorname',
                                'calculationperiod',
                                'referencenumber',
                                'paymentauthentication',
                                'paymentprotocol',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload',
                                'limiteespecial',
                                'documentnumber'
                            )
                            ->where('documentnumber','=',somenteNumeros($request->input('DocumentNumber')))
                            ->first();

        if(!$darf) return response()->json(['Success' => false, 'Message'=>'DocumentNumber e/ou Identifier não encontrado(s)'], 400);

        $darf->entryid = $request->input('EntryId');
        $darf->totalvalue = $request->input('TotalValue');
        $darf->status = $request->input('Status');
        $darf->paymentdate = $request->input('PaymentDate');
        $darf->returncode = $request->input('ReturnCode');
        $darf->returnmessage = $request->input('ReturnMessage');
        $darf->receipturl = $request->input('ReceiptUrl');
        $darf->coderevenue = $request->input('CodeRevenue');
        $darf->contributortaxnumber = $request->input('ContributorTaxNumber');
        $darf->finevalue = $request->input('FineValue');
        $darf->interestvalue = $request->input('InterestValue');
        $darf->valuerecipegrossaccumulated = $request->input('ValueRecipeGrossAccumulated');
        $darf->percentagerecipegrossaccumulated = $request->input('PercentageRecipeGrossAccumulated');
        $darf->duedate = $request->input('DueDate');
        $darf->contributorname = $request->input('ContributorName');
        if(!empty($request->input('CalculationPeriod'))) { $darf->calculationperiod = $request->input('CalculationPeriod'); }
        $darf->referencenumber = $request->input('ReferenceNumber');
        $darf->paymentauthentication = $request->input('PaymentAuthentication');
        $darf->paymentprotocol = $request->input('PaymentProtocol');
        $darf->sendernamebank = $request->input('SenderNameBank');
        $darf->sendercodebank = $request->input('SenderCodeBank');
        $darf->senderbranch = $request->input('SenderBranch');
        $darf->senderaccount = $request->input('SenderAccount');
        $darf->senderaccountdigit = $request->input('SenderAccountDigit');
        $darf->webhookpayload = $request->input();
        $darf->limiteespecial = $darf->limiteespecial;
        $darf->documentnumber = $darf->documentnumber;

        $darf->update();

        // DESFAZER O ADIANTAMENT EM CASO DE CANCELAMENTO OU ERRO
        // if($request->input('Status') == 'Cancel' && $darf->limiteespecial == 1) {
        //     desfazAdiantamento($darf->documentnumber, $request->input('Method'));
        // }


        $sucesso = (!$darf)?false:true;
        $protocolo = (!$darf)?400:200;
        $mensagem = (!$darf)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);
    }


    public function darj(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "documentnumber": "11378013794",
            "identifier": 5642,
        ***    "entryid": 12345,
            "totalvalue": 12345,
            "status": "paid",
            "paymentdate": "2018/03/30",
            "returncode ": 65432,
            "returnmessage": " mensagem",
            "origindocument": 2454,
            "coderevenue": 341,
            "contributortaxnumber": "41590989820",
            "finevalue": 54,
            "interestvalue": 4,
            "monetaryvalue": 54,
            "stateregistration ": 4,
            "duedate": "2018/03/30",
        ***    "contributorname": "josé silva",
            "referencenumber": 405,
            "paymentauthentication ": 4578,
        ***    "paymentprotocol": 4578,
            "sendernamebank": "itau",
            "sendercodebank": "341",
            "senderbranch": "1234",
            "senderaccount": "14555",
            "senderaccountdigit": "1"
        }
        */

        $darj = Darjpayment::select(
                                'id',
                                'entryid',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'returncode',
                                'returnmessage',
                                'receipturl',
                                'origindocument',
                                'coderevenue',
                                'contributortaxnumber',
                                'finevalue',
                                'interestvalue',
                                'monetaryvalue',
                                'stateregistration',
                                'duedate',
                                'contributorname',
                                'referencenumber',
                                'paymentauthentication',
                                'paymentprotocol',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',$request->input('DocumentNumber'))
                            ->first();
        
        if(!$darj) return response()->json(['Success' => false, 'Message'=>'DocumentNumber não encontrado'], 400);
        
        $darj->entryid = $request->input('EntryId');
        $darj->totalvalue = $request->input('TotalValue');
        $darj->status = $request->input('Status');
        $darj->paymentdate = $request->input('PaymentDate');
        $darj->returncode = $request->input('ReturnCode');
        $darj->returnmessage = $request->input('ReturnMessage');
        $darj->origindocument = $request->input('OriginDocument');
        $darj->coderevenue = $request->input('CodeRevenue');
        $darj->contributortaxnumber = $request->input('ContributorTaxNumber');
        $darj->finevalue = $request->input('FineValue');
        $darj->interestvalue = $request->input('InterestValue');
        $darj->monetaryvalue = $request->input('MonetaryValue');
        $darj->stateregistration = $request->input('StateRegistration');
        $darj->duedate = $request->input('DueDate');
        $darj->contributorname = $request->input('ContributorName');
        $darj->referencenumber = $request->input('ReferenceNumber');
        $darj->paymentauthentication = $request->input('PaymentAuthentication');
        $darj->paymentprotocol = $request->input('PaymentProtocol');
        $darj->sendernamebank = $request->input('SenderNameBank');
        $darj->sendercodebank = $request->input('SenderCodeBank');
        $darj->senderbranch = $request->input('SenderBranch');
        $darj->senderaccount = $request->input('SenderAccount');
        $darj->senderaccountdigit = $request->input('SenderAccountDigit');
        $darj->webhookpayload = $request->input();
        $darj->receipturl = $request->input('ReceiptUrl');

        $darj->update();

        $sucesso = (!$darj)?false:true;
        $protocolo = (!$darj)?400:200;
        $mensagem = (!$darj)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);
    }


    public function fgts(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "DocumentNumber": "11378013794",
            "Identifier": 5642,
            "EntryId": 12345,
            "TotalValue": 12345,
            "Status": "Paid",
            "PaymentDate": "2018/03/30",
            "ReturnCode ": 65432,
            "ReturnMessage": " Mensagem",
            "ReceiptUrl": "www.url.com.br",
            "CodeRevenue": 341,
            "ContributorTaxNumber": "06548754685",
            "Barcode ": "056485421000024520000",
            "FgtsIdentifier ": 54,
            "SocialConnectivityCode ": 4,
            "SocialConnectivityDigit ": 54,
            "DueDate": "2018/03/30",
            "ContributorName": "José Silva",
            "ReferenceNumber": 405,
            "PaymentAuthentication ": 4578,
            "PaymentProtocol": 4578,
            "SenderNameBank": "Itau",
            "SenderCodeBank": "341",
            "SenderBranch": "1234",
            "SenderAccount": "14555",
            "SenderAccountDigit": "1"
        }
        */

        $fgts = Fgtspayment::select(
                                'id',
                                'entryid',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'returncode',
                                'returnmessage',
                                'receipturl',
                                'coderevenue',
                                'contributortaxnumber',
                                'barcode',
                                'fgtsidentifier',
                                'socialconnectivitycode',
                                'socialconnectivitydigit',
                                'duedate',
                                'contributorname',
                                'referencenumber',
                                'paymentauthentication',
                                'paymentprotocol',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',$request->input('DocumentNumber'))
                            ->first();

        if(!$fgts) return response()->json(['Success' => false, 'Message'=>'DocumentNumber não encontrado'], 400);

        $fgts->entryid = $request->input('EntryId');
        $fgts->totalvalue = $request->input('TotalValue');
        $fgts->status = $request->input('Status');
        $fgts->paymentdate = $request->input('PaymentDate');
        $fgts->returncode = $request->input('ReturnCode');
        $fgts->returnmessage = $request->input('ReturnMessage');
        $fgts->receipturl = $request->input('ReceiptUrl');
        $fgts->coderevenue = $request->input('CodeRevenue');
        $fgts->contributortaxnumber = $request->input('ContributorTaxNumber');
        $fgts->barcode = $request->input('Barcode');
        $fgts->fgtsidentifier = $request->input('FgtsIdentifier');
        $fgts->socialconnectivitycode = $request->input('SocialConnectivityCode');
        $fgts->socialconnectivitydigit = $request->input('SocialConnectivityDigit');
        $fgts->duedate = $request->input('DueDate');
        $fgts->contributorname = $request->input('ContributorName');
        $fgts->referencenumber = $request->input('ReferenceNumber');
        $fgts->paymentauthentication = $request->input('PaymentAuthentication');
        $fgts->paymentprotocol = $request->input('PaymentProtocol');
        $fgts->sendernamebank = $request->input('SenderNameBank');
        $fgts->sendercodebank = $request->input('SenderCodeBank');
        $fgts->senderbranch = $request->input('SenderBranch');
        $fgts->senderaccount = $request->input('SenderAccount');
        $fgts->senderaccountdigit = $request->input('SenderAccountDigit');
        $fgts->webhookpayload = $request->input();

        $fgts->update();

        $sucesso = (!$fgts)?false:true;
        $protocolo = (!$fgts)?400:200;
        $mensagem = (!$fgts)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);

    }


    public function gare(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "documentnumber": "11378013794",
            "identifier": 5642,
        ***    "entryid": 12345,
            "totalvalue": 12345,
        ***    "status": "paid",   alterar pra varchar(30)
            "paymentdate": "2018/03/30",
            "returncode ": 65432,
            "returnmessage": " mensagem",
            "receipturl": "www.url.com.br",
            "coderevenue": 341,
            "contributortaxnumber": "41590989820",
            "finevalue": 54,
            "interestvalue": 4,
            "stateregistration ": 4,
            "duedate": "2018/03/30",
        ***    "contributorname": "josé silva",
            "activedebit": 10,
            "referencenumber": 405,
            "quotenumbernotification ": 10,
            "paymentauthentication ": 4578,
        ***    "paymentprotocol": 4578,
            "garetype": 4578,
            "sendernamebank": "itau",
            "sendercodebank": "341",
            "senderbranch": "1234",
            "senderaccount": "14555",
            "senderaccountdigit": "1"
        }
        */
        $gare = Garepayment::select(
                                'id',
                                'entryid',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'returncode',
                                'returnmessage',
                                'receipturl',
                                'coderevenue',
                                'contributortaxnumber',
                                'finevalue',
                                'interestvalue',
                                'stateregistration',
                                'contributorname',
                                'activedebit',
                                'referencenumber',
                                'quotenumbernotification',
                                'paymentauthentication',
                                'paymentprotocol',
                                'garetype',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',$request->input('DocumentNumber'))
                            ->first();

        if(!$gare) return response()->json(['Success' => false, 'Message'=>'DocumentNumber não encontrado'], 400);                    

        $gare->entryid = $request->input('EntryId');
        $gare->totalvalue = $request->input('TotalValue');
        $gare->status = $request->input('Status');
        $gare->paymentdate = $request->input('PaymentDate');
        $gare->returncode = $request->input('ReturnCode');
        $gare->returnmessage = $request->input('ReturnMessage');
        $gare->receipturl = $request->input('ReceiptUrl');
        $gare->coderevenue = $request->input('CodeRevenue');
        $gare->contributortaxnumber = $request->input('ContributorTaxNumber');
        $gare->finevalue = $request->input('FineValue');
        $gare->interestvalue = $request->input('InterestValue');
        $gare->stateregistration = $request->input('StateRegistration');
        $gare->contributorname = $request->input('ContributorName');
        $gare->activedebit = $request->input('ActiveDebit');
        $gare->referencenumber = $request->input('ReferenceNumber');
        $gare->quotenumbernotification = $request->input('QuoteNumberNotification');
        $gare->paymentauthentication = $request->input('PaymentAuthentication');
        $gare->paymentprotocol = $request->input('PaymentProtocol');
        $gare->garetype = $request->input('GareType');
        $gare->sendernamebank = $request->input('SenderNameBank');
        $gare->sendercodebank = $request->input('SenderCodeBank');
        $gare->senderbranch = $request->input('SenderBranch');
        $gare->senderaccount = $request->input('SenderAccount');
        $gare->senderaccountdigit = $request->input('SenderAccountDigit');
        $gare->webhookpayload = $request->input();

        $gare->update();

        $sucesso = (!$gare)?false:true;
        $protocolo = (!$gare)?400:200;
        $mensagem = (!$gare)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);
    }


    public function gps(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "documentnumber": "11378013794",
            "identifier": 5642,
        ***    "entryid": 12345,
            "totalvalue": 12345,
            "status": "paid",
            "paymentdate": "2018/03/30",
            "returncode ": 65432,
            "returnmessage": " mensagem",
            "receipturl": "www.url.com.br",
        ***    "gpsidentifier": 56425,
            "contributortaxnumber": "06548754685",
            "fineinterestvalue": 5,
            "othervalues ": 54,
            "jurisdictiondate ": "2018/03/31",
            "paymentcode": 54,
        ***    "duedate": "2018/03/30",
        ***    "contributorname": "josé silva",
            "referencenumber": 405,
            "paymentauthentication ": 4578,
        ***    "paymentprotocol": 4578,
            "sendernamebank": "itau",
            "sendercodebank": "341",
            "senderbranch": "1234",
            "senderaccount": "14555",
            "senderaccountdigit": "1"
        }
        */

        $gps = Gpspayment::select(
                                'id',
                                'entryid',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'returncode',
                                'returnmessage',
                                'receipturl',
                                'gpsidentifier',
                                'contributortaxnumber',
                                'fineinterestvalue',
                                'othervalues',
                                'jurisdictiondate',
                                'paymentcode',
                                'duedate',
                                'contributorname',
                                'referencenumber',
                                'paymentauthentication',
                                'paymentprotocol',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',$request->input('DocumentNumber'))
                            ->first();
        
        if(!$gps) return response()->json(['Success' => false, 'Message'=>'DocumentNumber não encontrado'], 400);

        $gps->entryid = $request->input('EntryId');
        $gps->totalvalue = $request->input('TotalValue');
        $gps->status = $request->input('Status');
        $gps->paymentdate = $request->input('PaymentDate');
        $gps->returncode = $request->input('ReturnCode');
        $gps->returnmessage = $request->input('ReturnMessage');
        $gps->receipturl = $request->input('ReceiptUrl');
        $gps->gpsidentifier = $request->input('GpsIdentifier');
        $gps->contributortaxnumber = $request->input('ContributorTaxNumber');
        $gps->fineinterestvalue = $request->input('FineInterestValue');
        $gps->othervalues = $request->input('OtherValues');
        $gps->jurisdictiondate = $request->input('JurisdictionDate');
        $gps->paymentcode = $request->input('PaymentCode');
        $gps->duedate = $request->input('DueDate');
        $gps->contributorname = $request->input('ContributorName');
        $gps->referencenumber = $request->input('ReferenceNumber');
        $gps->paymentauthentication = $request->input('PaymentAuthentication');
        $gps->paymentprotocol = $request->input('PaymentProtocol');
        $gps->sendernamebank = $request->input('SenderNameBank');
        $gps->sendercodebank = $request->input('SenderCodeBank');
        $gps->senderbranch = $request->input('SenderBranch');
        $gps->senderaccount = $request->input('SenderAccount');
        $gps->senderaccountdigit = $request->input('SenderAccountDigit');
        $gps->webhookpayload = $request->input();

        $gps->update();
        
        $sucesso = (!$gps)?false:true;
        $protocolo = (!$gps)?400:200;
        $mensagem = (!$gps)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);

    }


    public function transferenciabancaria(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "documentnumber": "11378013794",
            "identifier": 5642,
            "moneytransferdocumentnumber ": 12345,
            "entryid": 12345,
            "totalvalue": 12345,
            "status": "paid",
            "paymentdate": "2018/03/30",
            "returncode ": 65432,
            "bankcode": "341",
            "bankbranch ": "04314",
            "bankaccount": "645754",
            "bankaccountdigit": "054",
            "taxnumber": "06584215487",
            "receipturl": "www.url.com.br",
            "name": "josé ticio",
            "sendernamebank": "itau",
            "sendercodebank": "341",
            "senderbranch": "1234",
            "senderaccount": "14555",
            "senderaccountdigit": "1"
        }
        */

        $transferencia = Transferlog::select(
                                'id',
                                'moneytransferdocumentnumber',
                                'entryid',
                                'totalvalue',
                                'status',
                                'paymentdate',
                                'returncode',
                                'bankcode',
                                'bankbranch',
                                'bankaccount',
                                'bankaccountdigit',
                                'taxnumber',
                                'receipturl',
                                'name',
                                'sendernamebank',
                                'sendercodebank',
                                'senderbranch',
                                'senderaccount',
                                'senderaccountdigit',
                                'webhookpayload'
                            )
                            ->where('documentnumber','=',$request->input('DocumentNumber'))
                            ->where('identifier','=',$request->input('Identifier'))
                            ->first();
        
        if(!$transferencia) return response()->json(['Success' => false, 'Message'=>'DocumentNumber e/ou Identifier não encontrado(s)'], 400);

        $transferencia->moneytransferdocumentnumber = $request->input('MoneyTransferDocumentNumber');
        $transferencia->entryid = $request->input('EntryId');
        $transferencia->totalvalue = $request->input('TotalValue');
        $transferencia->status = $request->input('Status');
        $transferencia->paymentdate = $request->input('PaymentDate');
        $transferencia->returncode = $request->input('ReturnCode');
        $transferencia->bankcode = $request->input('BankCode');
        $transferencia->bankbranch = $request->input('BankBranch');
        $transferencia->bankaccount = $request->input('BankAccount');
        $transferencia->bankaccountdigit = $request->input('BankAccountDigit');
        $transferencia->taxnumber = $request->input('TaxNumber');
        $transferencia->receipturl = $request->input('ReceiptUrl');
        $transferencia->name = $request->input('Name');
        $transferencia->sendernamebank = $request->input('SenderNameBank');
        $transferencia->sendercodebank = $request->input('SenderCodeBank');
        $transferencia->senderbranch = $request->input('SenderBranch');
        $transferencia->senderaccount = $request->input('SenderAccount');
        $transferencia->senderaccountdigit = $request->input('SenderAccountDigit');
        $transferencia->webhookpayload = $request->input();

        $transferencia->update();
        $sucesso = (!$transferencia)?false:true;
        $protocolo = (!$transferencia)?400:200;
        $mensagem = (!$transferencia)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);
    }


    public function transferenciaclientefitbank(Request $request) {
        $webhookAuth = $this->authWebhook($request->header('Authorization'));
        if(!$webhookAuth) return response()->json(['Success' => false, 'Message'=>'Usuário ou senha inválido'], 400);

        /*
        {
            "MoneyTransferInDocumentNumber": "54662",
            "Name ": "Paulo M. Silva",
            "TaxNumber ": "487569851248",
            "Mail ": "empresa@teste.com",
            "Phone": "11-587458932",
            "BankCode": "510",
            "BankBranch": "10",
            "BankAccount": "4586",
            "RateValue": 4,
            "CreditedValue": 654,
            "TransferDate ": "2019/03/29",
            "PartnerId": 10,
            "DocumentNumber": "245484",
            "Identifier": "24fdgdf4834",
            "EntryId ": 8089,
            "Status": "Paid",
            "TotalValue": 8500,
            "PaymentDate": "2019/04/01",
            "FineInterest ": 9,
            "DiscountValue": 99,
            "IofValue": 1,
            "PaidValue": 4,
            "OtherValues": 1,
            "CreditDate ": "2019/04/20",
            "OccurrenceDate": "2019/05/03"
        }
        */


        $transferencia = Transactionlog::select(
                                'id',
                                'moneytransferindocumentnumber',
                                'name',
                                'taxnumber',
                                'mail',
                                'phone',
                                'bankcode',
                                'bankbranch',
                                'bankaccount',
                                'ratevalue',
                                'creditedvalue',
                                'transferdate',
                                'partnerid',
                                'documentnumber',
                                'identifier',
                                'entryid',
                                'status',
                                'totalvalue',
                                'paymentdate',
                                'fineinterest',
                                'discountvalue',
                                'iofvalue',
                                'paidvalue',
                                'othervalues',
                                'creditdate',
                                'occurrencedate',
                                'webhookpayload'
                            )
                            ->where('moneytransferindocumentnumber','=',$request->input('MoneyTransferInDocumentNumber'))
                            ->first();
        
        if(!$transferencia) return response()->json(['Success' => false, 'Message'=>'DocumentNumber e/ou Identifier não encontrado(s)'], 400);
        
        $transferencia->moneytransferindocumentnumber = $request->input('MoneyTransferInDocumentNumber');
        $transferencia->name = $request->input('Name');
        $transferencia->taxnumber = $request->input('TaxNumber');
        $transferencia->mail = $request->input('Mail');
        $transferencia->phone = $request->input('Phone');
        $transferencia->bankcode = $request->input('BankCode');
        $transferencia->bankbranch = $request->input('BankBranch');
        $transferencia->bankaccount = $request->input('BankAccount');
        $transferencia->ratevalue = $request->input('RateValue');
        $transferencia->creditedvalue = $request->input('CreditedValue');
        $transferencia->transferdate = $request->input('TransferDate');
        $transferencia->partnerid = $request->input('PartnerId');
        $transferencia->documentnumber = $request->input('DocumentNumber');
        $transferencia->identifier = $request->input('Identifier');
        $transferencia->entryid = $request->input('EntryId');
        $transferencia->status = $request->input('Status');
        $transferencia->totalvalue = $request->input('TotalValue');
        $transferencia->paymentdate = $request->input('PaymentDate');
        $transferencia->fineinterest = $request->input('FineInterest');
        $transferencia->discountvalue = $request->input('DiscountValue');
        $transferencia->iofvalue = $request->input('IofValue');
        $transferencia->paidvalue = $request->input('PaidValue');
        $transferencia->othervalues = $request->input('OtherValues');
        $transferencia->creditdate = $request->input('CreditDate');
        $transferencia->occurrencedate = $request->input('OccurrenceDate');

        $transferencia->webhookpayload = $request->input();

        $transferencia->update();
        $sucesso = (!$transferencia)?false:true;
        $protocolo = (!$transferencia)?400:200;
        $mensagem = (!$transferencia)?'Houve um problema ao processar a requisição':'Operação realizada com sucesso';

        return response()->json(['Success' => $sucesso, 'Message'=>$mensagem], $protocolo);
    }

    public function authWebhook($authorization) {
        if(empty($authorization)) return false;
        $authStr = explode(' ', $authorization);
        return (base64_decode($authStr[1]) == ('sps:sps@webh00k'))?true:false;
    }

    public function github(Request $request) {
        $secret = $request->header('X-Hub-Signature');

        // $payload = $request->input();
        // $output = array();

        $basePath = base_path();
        $process = new Process([$basePath.'/whook.sh']);
        $process->run();
        return array(
            'executed' => true,
            'process' => $process->getOutput()
        );
    }

}