<?php namespace App\Http\Controllers;

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\User;
use Hash;

use Illuminate\Mail\Message;
use Illuminate\Support\Facades\Password;

use App\Mail\EnviaMail;
use Illuminate\Support\Facades\Mail;

class UserWebController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function usuarios() {
    	$users = User::select('id','name','email','role_id','active')
    								->where('role_id',1)
    								->orderBy('active','desc')
    								->orderBy('name','asc')
    								->get();
		return view('users.index',compact('users'));
	}

	public function criaUsuario(Request $request) {

		$verificaEmail = verificaEmailExistente($request->email,'usuario');

		$url_retorno = ($request->client_id>0)?'clientes':'usuarios';

		if($verificaEmail) return redirect('/'.$url_retorno)->with('status', 'Já existe um usuário cadastrado com o email '.$request->email);

		if (!filter_var($request->email, FILTER_VALIDATE_EMAIL)) {
		    return redirect('/'.$url_retorno)->with('status', 'O formato do email fornecido parece inválido.');
		}

		$user = new User($request->all());
        $role_id = (isset($request->role_id))?$request->role_id:2;

        $novasenha = $this->randomPassword();
		$user->password  = Hash::make($novasenha);
		$user->role_id   = ($request->client_id>0)?$role_id:1;
		$user->client_id = ($request->client_id>0)?$request->client_id:0;
		$user->save();

        $mailstatus = '';

        if($user) {

            try {

                $mensagem = 'Olá, '.$request->name.'<br><br>';
                $mensagem .= 'Segue abaixo seus dados de acesso ao SSG Bank online<br><br>';
                $mensagem .= 'Usuário: '. $request->email .'<br>';
                $mensagem .= 'Senha: '. $novasenha .'<br><br><br>';
                $mensagem .= '<b>Lembre-se de trocar sua senha periodicamente</b><br><br>';
                $mensagem .= 'Obrigado por estar conosco!<br><br>';
                $mensagem .= '<a href="https://ssgbank.com.br/login">Acesse SSG Bank</a><br><br>';
                $mensagem .= 'Atenciosamente,<br><br>';
                $mensagem .= 'Equipe SSG Bank<br>';

                Mail::send(new EnviaMail($request->name, $request->email, 'Seu acesso ao SSG Bank', $mensagem));

                $mailstatus = 'E-mail enviado.';

            } catch(\Exception $e){
                // Get error here
                // $mailstatus = $e->getMessage();
                $mailstatus = 'Não foi possível enviar email.';
            }
        }

		return redirect('/'.$url_retorno)->with('status', 'Usuário '.$request->name.' criado com sucesso.'. $mailstatus);
	}

	public function atualizaUsuario(Request $request, $id) {
		$user = User::findOrFail($id);
		$user->update($request->all());

		if($request->client_id>0) return redirect('/clientes/'.$request->client_id.'/editar')->with('status', 'Usuário atualizado');

		return redirect('/usuarios')->with('status', $mensagem);
	}

	public function mudaStatusUsuario(Request $request, $id) {
		$user = User::findOrFail($id);
		$user->active = ($user->active==1)?0:1;
		$user->update();

		$mensagem = ($user->active==1)?'O usuário foi habilitado.':'O usuário foi desativado.';

		if($request->client_id>0) return redirect('/clientes/'.$request->client_id.'/editar')->with('status', $mensagem);

		$users = User::select('id','name','email','role_id','active')
    								->where('role_id',1)
    								->orderBy('active','desc')
    								->orderBy('name','asc')
    								->get();

		return view('users.index',compact('users'))->with('status', $mensagem);
	}


    public function mudarsenha() {
        return view('users.mudarsenha');
    }

	public function atualizarsenha(Request $request) {
        $userInfo = Auth::user();

        if($request->new_password == '' || strlen(trim($request->new_password)) < 8) {
            return redirect('usuario/mudarsenha')->with('warning','A nova senha deve ter pelo menos 8 caracteres.');
        }

        if($request->new_password != $request->new_password_confirm) {
            return redirect('usuario/mudarsenha')->with('warning','As senhas digitadas não conferem.');
        }

        if (Hash::check($request->currentpassword, $userInfo->password)) {
            if(strlen(trim($request->new_password)) > 7) {
                $user = User::findOrFail($userInfo->id);
                $user->update(['password'=>Hash::make($request->new_password)]);
                if(!$user) return view('usuario/mudarsenha')->with('warning','Ocorreu um erro ao atualizar.');
                return redirect('usuario/mudarsenha')->with('status','Senha atualizada com sucesso!');
            } else {
                return redirect('usuario/mudarsenha')->with('warning','A senha deve ter pelo menos 8 caracteres.');
            }
        } else {
            return redirect('usuario/mudarsenha')->with('warning','Você deve digitar sua senha atual para fazer alterações no cadastro!');
        }

    }


    public function sendResetPasswordLink(Request $request)
    {
        $credentials = ['email' => $request->useremail];
        $response = Password::sendResetLink($credentials, function (Message $message) {
            $message->subject($this->getEmailSubject());
        });

        switch ($response) {
            case Password::RESET_LINK_SENT:
                return redirect('clientes')->with('success', 'Link enviado para '.$request->useremail.' com sucesso.');
            case Password::INVALID_USER:
                return redirect('clientes')->with(['danger' => 'Erro ao enviar link para '.$request->useremail.'.']);
        }
    }

    public function randomPassword() {
        $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
        $pass = array(); //remember to declare $pass as an array
        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
        for ($i = 0; $i < 8; $i++) {
            $n = rand(0, $alphaLength);
            $pass[] = $alphabet[$n];
        }
        return implode($pass); //turn the array into a string
    }
}

